/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.hwp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.hwp.HwpTextExtractorV5;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HwpV5Parser
extends AbstractParser {
    public static final String HWP_MIME_TYPE = "application/x-hwp-v5";
    private static final long serialVersionUID = 1L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("x-hwp-v5"));
    private HwpTextExtractorV5 extractor = new HwpTextExtractorV5();

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", HWP_MIME_TYPE);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            this.extractor.extract(stream, metadata, xhtml);
        }
        finally {
            xhtml.endDocument();
        }
    }
}

