/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import jakarta.mail.Flags;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;

public class ComposedMessageIdWithMetaData {
    private final ComposedMessageId composedMessageId;
    private final Flags flags;
    private final ModSeq modSeq;
    private final ThreadId threadId;

    public static Builder builder() {
        return new Builder();
    }

    public ComposedMessageIdWithMetaData(ComposedMessageId composedMessageId, Flags flags, ModSeq modSeq, ThreadId threadId) {
        this.composedMessageId = composedMessageId;
        this.flags = flags;
        this.modSeq = modSeq;
        this.threadId = threadId;
    }

    public ComposedMessageId getComposedMessageId() {
        return this.composedMessageId;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public ModSeq getModSeq() {
        return this.modSeq;
    }

    public ThreadId getThreadId() {
        return this.threadId;
    }

    public boolean isMatching(MessageId messageId) {
        return this.getComposedMessageId().getMessageId().equals(messageId);
    }

    public final boolean equals(Object o) {
        if (o instanceof ComposedMessageIdWithMetaData) {
            ComposedMessageIdWithMetaData other = (ComposedMessageIdWithMetaData)o;
            return Objects.equal(this.composedMessageId, other.composedMessageId) && Objects.equal(this.flags, other.flags) && Objects.equal(this.modSeq, other.modSeq) && Objects.equal(this.threadId, other.threadId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.composedMessageId, this.flags, this.modSeq, this.threadId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("composedMessageId", this.composedMessageId).add("flags", this.flags).add("modSeq", this.modSeq).add("threadId", this.threadId).toString();
    }

    public static class Builder {
        private ComposedMessageId composedMessageId;
        private Flags flags;
        private ModSeq modSeq;
        private ThreadId threadId;

        private Builder() {
        }

        public Builder composedMessageId(ComposedMessageId composedMessageId) {
            this.composedMessageId = composedMessageId;
            return this;
        }

        public Builder flags(Flags flags) {
            this.flags = flags;
            return this;
        }

        public Builder modSeq(ModSeq modSeq) {
            this.modSeq = modSeq;
            return this;
        }

        public Builder threadId(ThreadId threadId) {
            this.threadId = threadId;
            return this;
        }

        public ComposedMessageIdWithMetaData build() {
            Preconditions.checkNotNull(this.composedMessageId, "'composedMessageId' is mandatory");
            Preconditions.checkNotNull(this.flags, "'flags' is mandatory");
            Preconditions.checkNotNull(this.modSeq, "'modSeq' is mandatory");
            Preconditions.checkNotNull(this.threadId, "'threadId' is mandatory");
            return new ComposedMessageIdWithMetaData(this.composedMessageId, this.flags, this.modSeq, this.threadId);
        }
    }
}

