/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.translate.LookupTranslator;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.HasEmptyMailboxNameInHierarchyException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;

public class MailboxPath {
    private static final Splitter PART_SPLITTER = Splitter.on(':');
    private static final Joiner PARTS_JOINER = Joiner.on(':');
    private static final LookupTranslator USERNAME_ESCAPER = new LookupTranslator(Map.of(":", "/;", "/", "//"));
    private static final LookupTranslator USERNAME_UNESCAPER = new LookupTranslator(Map.of("/;", ":", "//", "/"));
    private static final String INVALID_CHARS = "%*\r\n";
    private static final CharMatcher INVALID_CHARS_MATCHER = CharMatcher.anyOf("%*\r\n");
    public static final int MAX_MAILBOX_NAME_LENGTH = 200;
    private final String namespace;
    private final Username user;
    private final String name;

    public static MailboxPath inbox(MailboxSession session) {
        return MailboxPath.inbox(session.getUser());
    }

    public static MailboxPath inbox(Username username) {
        return MailboxPath.forUser(username, "INBOX");
    }

    public static MailboxPath forUser(Username username, String mailboxName) {
        return new MailboxPath("#private", username, mailboxName);
    }

    public static Optional<MailboxPath> parseEscaped(String asEscapedString) {
        List<String> parts = PART_SPLITTER.splitToList(asEscapedString);
        if (parts.size() == 2) {
            return Optional.of(new MailboxPath(parts.get(0), MailboxPath.getUsername(parts), ""));
        }
        if (parts.size() == 3) {
            return Optional.of(new MailboxPath(parts.get(0), MailboxPath.getUsername(parts), parts.get(2)));
        }
        if (parts.size() > 3) {
            return Optional.of(new MailboxPath(parts.get(0), MailboxPath.getUsername(parts), PARTS_JOINER.join(Iterables.skip(parts, 2))));
        }
        return Optional.empty();
    }

    private static Username getUsername(List<String> parts) {
        return Username.of(USERNAME_UNESCAPER.translate(parts.get(1)));
    }

    public MailboxPath(String namespace, Username user, String name) {
        this.namespace = Optional.ofNullable(namespace).filter(Predicate.not(String::isEmpty)).orElse("#private");
        this.user = user;
        this.name = name;
    }

    public MailboxPath(MailboxPath mailboxPath) {
        this(mailboxPath.getNamespace(), mailboxPath.getUser(), mailboxPath.getName());
    }

    public MailboxPath(MailboxPath mailboxPath, String name) {
        this(mailboxPath.getNamespace(), mailboxPath.getUser(), name);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Username getUser() {
        return this.user;
    }

    public MailboxPath withUser(Username username) {
        return new MailboxPath(this.namespace, username, this.name);
    }

    public String getName() {
        return this.name;
    }

    public boolean belongsTo(MailboxSession mailboxSession) {
        return this.user.equals(mailboxSession.getUser());
    }

    public MailboxPath child(String childName, char delimiter) {
        Preconditions.checkArgument(!StringUtils.isBlank(childName), "'childName' should not be null or empty");
        Preconditions.checkArgument(!childName.contains(String.valueOf(delimiter)), "'childName' should not contain delimiter");
        return new MailboxPath(this.namespace, this.user, this.name + delimiter + childName);
    }

    public List<MailboxPath> getHierarchyLevels(char delimiter) {
        if (this.name == null) {
            return ImmutableList.of(this);
        }
        List<MailboxPath> levels = this.getParents(delimiter);
        levels.add(this);
        return levels;
    }

    public List<MailboxPath> getParents(char delimiter) {
        if (this.name == null) {
            return ImmutableList.of();
        }
        ArrayList<MailboxPath> levels = new ArrayList<MailboxPath>();
        int index = this.name.indexOf(delimiter);
        while (index >= 0) {
            String levelName = this.name.substring(0, index);
            levels.add(new MailboxPath(this.namespace, this.user, levelName));
            ++index;
            index = this.name.indexOf(delimiter, index);
        }
        return levels;
    }

    public String getName(char delimiter) {
        return Iterables.getLast(Splitter.on(delimiter).splitToList(this.name));
    }

    public MailboxPath sanitize(char delimiter) {
        if (this.name == null) {
            return this;
        }
        if (this.name.endsWith(String.valueOf(delimiter))) {
            int length = this.name.length();
            String sanitizedName = this.name.substring(0, length - 1);
            return new MailboxPath(this.namespace, this.user, sanitizedName);
        }
        return this;
    }

    public MailboxPath assertAcceptable(char pathDelimiter) throws MailboxNameException {
        if (this.hasEmptyNameInHierarchy(pathDelimiter)) {
            throw new HasEmptyMailboxNameInHierarchyException(String.format("'%s' has an empty part within its mailbox name considering %s as a delimiter", this.asString(), Character.valueOf(pathDelimiter)));
        }
        if (this.nameContainsForbiddenCharacters()) {
            throw new MailboxNameException(this.asString() + " contains one of the forbidden characters %*\r\n or starts with #");
        }
        if (this.isMailboxNameTooLong()) {
            throw new TooLongMailboxNameException("Mailbox name exceeds maximum size of 200 characters");
        }
        return this;
    }

    private boolean nameContainsForbiddenCharacters() {
        return INVALID_CHARS_MATCHER.matchesAnyOf(this.name) || this.name.startsWith("#");
    }

    private boolean isMailboxNameTooLong() {
        return this.name.length() > 200;
    }

    boolean hasEmptyNameInHierarchy(char pathDelimiter) {
        String delimiterString = String.valueOf(pathDelimiter);
        String nameWithoutSpaces = StringUtils.deleteWhitespace(this.name);
        return StringUtils.isBlank(nameWithoutSpaces) || nameWithoutSpaces.contains(delimiterString + delimiterString) || nameWithoutSpaces.startsWith(delimiterString) || nameWithoutSpaces.endsWith(delimiterString);
    }

    public String asString() {
        return this.namespace + ":" + this.user.asString() + ":" + this.name;
    }

    public String asEscapedString() {
        return this.namespace + ":" + USERNAME_ESCAPER.translate(this.user.asString()) + ":" + this.name;
    }

    public boolean isInbox() {
        return "INBOX".equalsIgnoreCase(this.name);
    }

    public String toString() {
        return this.asString();
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxPath) {
            MailboxPath that = (MailboxPath)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.user, that.user) && Objects.equals(this.name, that.name);
        }
        return false;
    }

    public final int hashCode() {
        int result = 1;
        result += result * 31 + this.namespace.hashCode();
        result += result * 31 + Objects.hashCode(this.user);
        result += result * 31 + Objects.hashCode(this.name);
        return result;
    }

    @Deprecated
    public String getFullName(char delimiter) {
        return this.namespace + delimiter + this.name;
    }

    public boolean hasParent(char delimiter) {
        return this.name.indexOf(delimiter) >= 0;
    }
}

