/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.FluxPeekFuseable;
import reactor.core.publisher.InternalProducerAttr;
import reactor.core.publisher.ParallelFlux;
import reactor.core.publisher.SignalPeek;
import reactor.util.annotation.Nullable;

final class ParallelPeek<T>
extends ParallelFlux<T>
implements SignalPeek<T> {
    final ParallelFlux<T> source;
    final Consumer<? super T> onNext;
    final Consumer<? super T> onAfterNext;
    final Consumer<? super Throwable> onError;
    final Runnable onComplete;
    final Runnable onAfterTerminated;
    final Consumer<? super Subscription> onSubscribe;
    final LongConsumer onRequest;
    final Runnable onCancel;

    ParallelPeek(ParallelFlux<T> source, @Nullable Consumer<? super T> onNext, @Nullable Consumer<? super T> onAfterNext, @Nullable Consumer<? super Throwable> onError2, @Nullable Runnable onComplete, @Nullable Runnable onAfterTerminated, @Nullable Consumer<? super Subscription> onSubscribe, @Nullable LongConsumer onRequest, @Nullable Runnable onCancel) {
        this.source = ParallelFlux.from(source);
        this.onNext = onNext;
        this.onAfterNext = onAfterNext;
        this.onError = onError2;
        this.onComplete = onComplete;
        this.onAfterTerminated = onAfterTerminated;
        this.onSubscribe = onSubscribe;
        this.onRequest = onRequest;
        this.onCancel = onCancel;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        CoreSubscriber[] parents = new CoreSubscriber[n];
        boolean conditional = subscribers[0] instanceof Fuseable.ConditionalSubscriber;
        for (int i = 0; i < n; ++i) {
            parents[i] = conditional ? new FluxPeekFuseable.PeekConditionalSubscriber((Fuseable.ConditionalSubscriber)subscribers[i], this) : new FluxPeek.PeekSubscriber<T>(subscribers[i], this);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    @Nullable
    public Consumer<? super Subscription> onSubscribeCall() {
        return this.onSubscribe;
    }

    @Override
    @Nullable
    public Consumer<? super T> onNextCall() {
        return this.onNext;
    }

    @Override
    @Nullable
    public Consumer<? super Throwable> onErrorCall() {
        return this.onError;
    }

    @Override
    @Nullable
    public Runnable onCompleteCall() {
        return this.onComplete;
    }

    @Override
    public Runnable onAfterTerminateCall() {
        return this.onAfterTerminated;
    }

    @Override
    @Nullable
    public LongConsumer onRequestCall() {
        return this.onRequest;
    }

    @Override
    @Nullable
    public Runnable onCancelCall() {
        return this.onCancel;
    }

    @Override
    @Nullable
    public Consumer<? super T> onAfterNextCall() {
        return this.onAfterNext;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return null;
    }
}

