/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class AdjacencyMatrixAggregation
extends BucketAggregationBase
implements AggregationVariant {
    private final Map<String, Query> filters;
    public static final JsonpDeserializer<AdjacencyMatrixAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdjacencyMatrixAggregation::setupAdjacencyMatrixAggregationDeserializer);

    private AdjacencyMatrixAggregation(Builder builder) {
        super(builder);
        this.filters = ApiTypeHelper.unmodifiable(builder.filters);
    }

    public static AdjacencyMatrixAggregation of(Function<Builder, ObjectBuilder<AdjacencyMatrixAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.AdjacencyMatrix;
    }

    public final Map<String, Query> filters() {
        return this.filters;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.filters)) {
            generator.writeKey("filters");
            generator.writeStartObject();
            for (Map.Entry<String, Query> item0 : this.filters.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupAdjacencyMatrixAggregationDeserializer(ObjectDeserializer<Builder> op) {
        AdjacencyMatrixAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::filters, JsonpDeserializer.stringMapDeserializer(Query._DESERIALIZER), "filters");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AdjacencyMatrixAggregation> {
        @Nullable
        private Map<String, Query> filters;

        public final Builder filters(Map<String, Query> map) {
            this.filters = Builder._mapPutAll(this.filters, map);
            return this;
        }

        public final Builder filters(String key, Query value) {
            this.filters = Builder._mapPut(this.filters, key, value);
            return this;
        }

        public final Builder filters(String key, Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filters(key, fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AdjacencyMatrixAggregation build() {
            this._checkSingleUse();
            return new AdjacencyMatrixAggregation(this);
        }
    }
}

