/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.Bytes;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.IndicesResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

public class IndicesRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final HealthStatus health;
    @Nullable
    private final Boolean includeUnloadedSegments;
    private final List<String> index;
    @Nullable
    private final Boolean pri;
    public static final Endpoint<IndicesRequest, IndicesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<IndicesRequest, IndicesResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/indices");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/indices");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>(request.queryParameters());
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (request.pri != null) {
            params.put("pri", String.valueOf(request.pri));
        }
        if (request.health != null) {
            params.put("health", request.health.jsonValue());
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, IndicesResponse._DESERIALIZER);

    private IndicesRequest(Builder builder) {
        super(builder);
        this.bytes = builder.bytes;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.health = builder.health;
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.pri = builder.pri;
    }

    public static IndicesRequest of(Function<Builder, ObjectBuilder<IndicesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final HealthStatus health() {
        return this.health;
    }

    @Nullable
    public final Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Boolean pri() {
        return this.pri;
    }

    public static class Builder
    extends CatRequestBase.CatRequestBaseBuilder<Builder> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private HealthStatus health;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean pri;

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder health(@Nullable HealthStatus value) {
            this.health = value;
            return this;
        }

        public final Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder pri(@Nullable Boolean value) {
            this.pri = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public IndicesRequest build() {
            this._checkSingleUse();
            return new IndicesRequest(this);
        }
    }
}

