/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class AdaptiveSelection
implements PlainJsonSerializable {
    private final long avgQueueSize;
    private final long avgResponseTimeNs;
    private final long avgServiceTimeNs;
    private final long outgoingSearches;
    private final String rank;
    public static final JsonpDeserializer<AdaptiveSelection> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdaptiveSelection::setupAdaptiveSelectionDeserializer);

    private AdaptiveSelection(Builder builder) {
        this.avgQueueSize = ApiTypeHelper.requireNonNull(builder.avgQueueSize, this, "avgQueueSize");
        this.avgResponseTimeNs = ApiTypeHelper.requireNonNull(builder.avgResponseTimeNs, this, "avgResponseTimeNs");
        this.avgServiceTimeNs = ApiTypeHelper.requireNonNull(builder.avgServiceTimeNs, this, "avgServiceTimeNs");
        this.outgoingSearches = ApiTypeHelper.requireNonNull(builder.outgoingSearches, this, "outgoingSearches");
        this.rank = ApiTypeHelper.requireNonNull(builder.rank, this, "rank");
    }

    public static AdaptiveSelection of(Function<Builder, ObjectBuilder<AdaptiveSelection>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long avgQueueSize() {
        return this.avgQueueSize;
    }

    public final long avgResponseTimeNs() {
        return this.avgResponseTimeNs;
    }

    public final long avgServiceTimeNs() {
        return this.avgServiceTimeNs;
    }

    public final long outgoingSearches() {
        return this.outgoingSearches;
    }

    public final String rank() {
        return this.rank;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("avg_queue_size");
        generator.write(this.avgQueueSize);
        generator.writeKey("avg_response_time_ns");
        generator.write(this.avgResponseTimeNs);
        generator.writeKey("avg_service_time_ns");
        generator.write(this.avgServiceTimeNs);
        generator.writeKey("outgoing_searches");
        generator.write(this.outgoingSearches);
        generator.writeKey("rank");
        generator.write(this.rank);
    }

    protected static void setupAdaptiveSelectionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::avgQueueSize, JsonpDeserializer.longDeserializer(), "avg_queue_size");
        op.add(Builder::avgResponseTimeNs, JsonpDeserializer.longDeserializer(), "avg_response_time_ns");
        op.add(Builder::avgServiceTimeNs, JsonpDeserializer.longDeserializer(), "avg_service_time_ns");
        op.add(Builder::outgoingSearches, JsonpDeserializer.longDeserializer(), "outgoing_searches");
        op.add(Builder::rank, JsonpDeserializer.stringDeserializer(), "rank");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<AdaptiveSelection> {
        private Long avgQueueSize;
        private Long avgResponseTimeNs;
        private Long avgServiceTimeNs;
        private Long outgoingSearches;
        private String rank;

        public final Builder avgQueueSize(long value) {
            this.avgQueueSize = value;
            return this;
        }

        public final Builder avgResponseTimeNs(long value) {
            this.avgResponseTimeNs = value;
            return this;
        }

        public final Builder avgServiceTimeNs(long value) {
            this.avgServiceTimeNs = value;
            return this;
        }

        public final Builder outgoingSearches(long value) {
            this.outgoingSearches = value;
            return this;
        }

        public final Builder rank(String value) {
            this.rank = value;
            return this;
        }

        @Override
        public AdaptiveSelection build() {
            this._checkSingleUse();
            return new AdaptiveSelection(this);
        }
    }
}

