/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import java.util.Optional;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;

public class QuotaDomainDTO {
    private final Optional<ValidatedQuotaDTO> global;
    private final Optional<ValidatedQuotaDTO> domain;
    private final Optional<ValidatedQuotaDTO> computed;

    public static Builder builder() {
        return new Builder();
    }

    private QuotaDomainDTO(Optional<ValidatedQuotaDTO> global, Optional<ValidatedQuotaDTO> domain, Optional<ValidatedQuotaDTO> computed) {
        this.global = global;
        this.domain = domain;
        this.computed = computed;
    }

    public Optional<ValidatedQuotaDTO> getGlobal() {
        return this.global;
    }

    public Optional<ValidatedQuotaDTO> getDomain() {
        return this.domain;
    }

    public Optional<ValidatedQuotaDTO> getComputed() {
        return this.computed;
    }

    public static class Builder {
        private Optional<ValidatedQuotaDTO> global = Optional.empty();
        private Optional<ValidatedQuotaDTO> domain;
        private Optional<ValidatedQuotaDTO> computed = Optional.empty();

        private Builder() {
        }

        public Builder global(ValidatedQuotaDTO.Builder global) {
            this.global = Optional.of(global.build());
            return this;
        }

        public Builder domain(ValidatedQuotaDTO.Builder domain) {
            this.domain = Optional.of(domain.build());
            return this;
        }

        public Builder computed(ValidatedQuotaDTO.Builder computed) {
            this.computed = Optional.of(computed.build());
            return this;
        }

        public QuotaDomainDTO build() {
            return new QuotaDomainDTO(this.global, this.domain, this.computed);
        }
    }
}

