/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.quota.search.Limit;
import org.apache.james.quota.search.Offset;
import org.apache.james.quota.search.QuotaBoundary;
import org.apache.james.quota.search.QuotaClause;

public class QuotaQuery {
    private final QuotaClause.And clause;
    private final Limit limit;
    private final Offset offset;

    public static Builder builder() {
        return new Builder();
    }

    private QuotaQuery(QuotaClause.And clause, Limit limit, Offset offset) {
        this.clause = clause;
        this.limit = limit;
        this.offset = offset;
    }

    public QuotaClause.And getClause() {
        return this.clause;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaQuery) {
            QuotaQuery that = (QuotaQuery)o;
            return Objects.equals(this.clause, that.clause) && Objects.equals(this.limit, that.limit) && Objects.equals(this.offset, that.offset);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.clause, this.limit, this.offset);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clause", (Object)this.clause).add("limit", (Object)this.limit).add("offset", (Object)this.offset).toString();
    }

    public static class Builder {
        private ImmutableList.Builder<QuotaClause> clauses = ImmutableList.builder();
        private Optional<Limit> limit = Optional.empty();
        private Optional<Offset> offset = Optional.empty();

        private Builder() {
        }

        public Builder moreThan(QuotaBoundary quotaBoundary) {
            this.clauses.add((Object)QuotaClause.moreThan(quotaBoundary));
            return this;
        }

        public Builder moreThan(Optional<QuotaBoundary> quotaBoundary) {
            quotaBoundary.ifPresent(this::moreThan);
            return this;
        }

        public Builder lessThan(QuotaBoundary quotaBoundary) {
            this.clauses.add((Object)QuotaClause.lessThan(quotaBoundary));
            return this;
        }

        public Builder lessThan(Optional<QuotaBoundary> quotaBoundary) {
            quotaBoundary.ifPresent(this::lessThan);
            return this;
        }

        public Builder hasDomain(Domain domain) {
            this.clauses.add((Object)QuotaClause.hasDomain(domain));
            return this;
        }

        public Builder hasDomain(Optional<Domain> domain) {
            domain.ifPresent(this::hasDomain);
            return this;
        }

        public Builder withLimit(Limit limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        public Builder withOffset(Offset offset) {
            this.offset = Optional.of(offset);
            return this;
        }

        public QuotaQuery build() {
            return new QuotaQuery(QuotaClause.and((List<QuotaClause>)this.clauses.build()), this.limit.orElse(Limit.unlimited()), this.offset.orElse(Offset.none()));
        }
    }
}

