/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Set;
import org.apache.james.jmap.core.CapabilityFactory;
import org.apache.james.jmap.core.ClientId;
import org.apache.james.jmap.core.ErrorCode$InvalidResultReference$;
import org.apache.james.jmap.core.ErrorCode$ServerFail$;
import org.apache.james.jmap.core.ErrorCode$UnknownMethod$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.MaxCallsInRequest$;
import org.apache.james.jmap.core.MissingCapabilityException;
import org.apache.james.jmap.core.RequestObject;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.ServerId;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.routes.InvalidResultReferenceException;
import org.apache.james.jmap.routes.JMAPApi$;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.TooManyCallsInRequest;
import org.apache.james.jmap.routes.UnsupportedCapabilitiesException;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SFluxLike;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u00055w!\u0002\u000b\u0016\u0011\u0003\u0001c!\u0002\u0012\u0016\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0005\u0004%\t!\f\u0005\u0007i\u0005\u0001\u000b\u0011\u0002\u0018\u0007\t\t*\u0002!\u000e\u0005\tm\u0015\u0011\t\u0011)A\u0005o!A\u0001*\u0002B\u0001B\u0003%\u0011\n\u0003\u0005^\u000b\t\u0005\t\u0015!\u0003_\u0011\u0015QS\u0001\"\u0001c\u0011\u001d9WA1A\u0005\n!Daa]\u0003!\u0002\u0013I\u0007\"\u0002\u0016\u0006\t\u0003!\bbBA\u000f\u000b\u0011\u0005\u0011q\u0004\u0005\b\u0003+*A\u0011BA,\u0011\u001d\t\u0019(\u0002C\u0005\u0003kBq!!\u001f\u0006\t\u0013\tY\bC\u0004\u0002\u001e\u0015!I!!(\t\u000f\u00055V\u0001\"\u0003\u00020\"9\u0011QK\u0003\u0005\n\u0005]\u0016a\u0002&N\u0003B\u000b\u0005/\u001b\u0006\u0003-]\taA]8vi\u0016\u001c(B\u0001\r\u001a\u0003\u0011QW.\u00199\u000b\u0005iY\u0012!\u00026b[\u0016\u001c(B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\"\u00035\tQCA\u0004K\u001b\u0006\u0003\u0016\t]5\u0014\u0005\u0005!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002A\u00051AjT$H\u000bJ+\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003cu\tQa\u001d7gi)L!a\r\u0019\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\u001a\"!\u0002\u0013\u0002\u000f5,G\u000f[8egB\u0019\u0001h\u0010\"\u000f\u0005ej\u0004C\u0001\u001e'\u001b\u0005Y$B\u0001\u001f \u0003\u0019a$o\\8u}%\u0011aHJ\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%aA*fi*\u0011aH\n\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b^\ta!\\3uQ>$\u0017BA$E\u0005\u0019iU\r\u001e5pI\u0006\u0019B-\u001a4bk2$8)\u00199bE&d\u0017\u000e^5fgB\u0019\u0001h\u0010&\u0011\u0005-SfB\u0001'X\u001d\tiUK\u0004\u0002O):\u0011qj\u0015\b\u0003!Js!AO)\n\u0003yI!\u0001H\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\t1v#\u0001\u0003d_J,\u0017B\u0001-Z\u0003Q\u0019\u0015\r]1cS2LG/_%eK:$\u0018NZ5fe*\u0011akF\u0005\u00037r\u0013AcQ1qC\nLG.\u001b;z\u0013\u0012,g\u000e^5gS\u0016\u0014(B\u0001-Z\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011q\fY\u0007\u00023&\u0011\u0011-\u0017\u0002\u0019\u00156\f\u0007O\u00154dqY\u0012\u0014gQ8oM&<WO]1uS>tG\u0003B2eK\u001a\u0004\"!I\u0003\t\u000bYJ\u0001\u0019A\u001c\t\u000b!K\u0001\u0019A%\t\u000buK\u0001\u0019\u00010\u0002\u001b5,G\u000f[8eg\nKh*Y7f+\u0005I\u0007\u0003\u0002\u001dkY\nK!a[!\u0003\u00075\u000b\u0007\u000f\u0005\u0002na:\u0011AJ\\\u0005\u0003_f\u000b!\"\u00138w_\u000e\fG/[8o\u0013\t\t(O\u0001\u0006NKRDw\u000e\u001a(b[\u0016T!a\\-\u0002\u001d5,G\u000f[8eg\nKh*Y7fAQ)1-\u001e@\u0002\n!)a\u000f\u0004a\u0001o\u0006Y!.\u0019<b\u001b\u0016$\bn\u001c3t!\rAXPQ\u0007\u0002s*\u0011!p_\u0001\u0005kRLGNC\u0001}\u0003\u0011Q\u0017M^1\n\u0005\u0001K\bBB@\r\u0001\u0004\t\t!A\u000btkB\u0004xN\u001d;fI\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0011\tal\u00181\u0001\t\u0004?\u0006\u0015\u0011bAA\u00043\n\t2)\u00199bE&d\u0017\u000e^=GC\u000e$xN]=\t\u000buc\u0001\u0019\u00010)\u00071\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\r%t'.Z2u\u0015\t\t9\"A\u0004kC.\f'\u000f^1\n\t\u0005m\u0011\u0011\u0003\u0002\u0007\u0013:TWm\u0019;\u0002\u000fA\u0014xnY3tgR1\u0011\u0011EA\u001e\u0003\u000b\u0002b!a\t\u00022\u0005URBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0013A,(\r\\5tQ\u0016\u0014(bA\u0014\u0002,)\u0019a+!\f\u000b\u0005\u0005=\u0012a\u0002:fC\u000e$xN]\u0005\u0005\u0003g\t)CA\u0003T\u001b>tw\u000eE\u0002`\u0003oI1!!\u000fZ\u00059\u0011Vm\u001d9p]N,wJ\u00196fGRDq!!\u0010\u000e\u0001\u0004\ty$A\u0007sKF,Xm\u001d;PE*,7\r\u001e\t\u0004?\u0006\u0005\u0013bAA\"3\ni!+Z9vKN$xJ\u00196fGRDq!a\u0012\u000e\u0001\u0004\tI%\u0001\bnC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014\u001a\u0003\u001di\u0017-\u001b7c_bLA!a\u0015\u0002N\tqQ*Y5mE>D8+Z:tS>t\u0017\u0001\u0006<bY&$\u0017\r^3DCB\f'-\u001b7ji&,7\u000f\u0006\u0003\u0002Z\u0005E\u0004\u0003CA.\u0003K\nY'a\u0010\u000f\t\u0005u\u0013\u0011\r\b\u0004u\u0005}\u0013\"A\u0014\n\u0007\u0005\rd%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005\rd\u0005\u0005\u0003\u0002\\\u00055\u0014\u0002BA8\u0003S\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\t\u000f\u0005ub\u00021\u0001\u0002@\u0005\u0001b/\u00197jI\u0006$X-T1y\u0007\u0006dGn\u001d\u000b\u0005\u00033\n9\bC\u0004\u0002>=\u0001\r!a\u0010\u0002GA\u0014xnY3tgN+\u0017/^3oi&\fG\u000e\\=B]\u0012,\u0006\u000fZ1uK\u000e{g\u000e^3yiRQ\u0011QPAF\u0003\u001b\u000by)!'\u0011\r\u0005\r\u0012\u0011GA@!\u0019\tY&!!\u0002\u0006&!\u00111QA5\u0005\r\u0019V-\u001d\t\u0004\u0007\u0006\u001d\u0015bAAE\t\n)\u0012J\u001c<pG\u0006$\u0018n\u001c8XSRD7i\u001c8uKb$\bbBA\u001f!\u0001\u0007\u0011q\b\u0005\b\u0003\u000f\u0002\u0002\u0019AA%\u0011\u001d\t\t\n\u0005a\u0001\u0003'\u000b\u0011\u0003\u001d:pG\u0016\u001c8/\u001b8h\u0007>tG/\u001a=u!\r\t\u0013QS\u0005\u0004\u0003/+\"!\u0005)s_\u000e,7o]5oO\u000e{g\u000e^3yi\"1\u00111\u0014\tA\u0002%\u000bAbY1qC\nLG.\u001b;jKN$\u0002\"a(\u0002&\u0006\u001d\u0016\u0011\u0016\t\u0007\u0003G\t\t+!\"\n\t\u0005\r\u0016Q\u0005\u0002\u0006'\u001acW\u000f\u001f\u0005\u0007\u00037\u000b\u0002\u0019A%\t\u000f\u0005\u001d\u0013\u00031\u0001\u0002J!9\u00111V\tA\u0002\u0005\u0015\u0015AC5om>\u001c\u0017\r^5p]\u0006Q\u0002O]8dKN\u001cX*\u001a;i_\u0012<\u0016\u000e\u001e5NCR\u001c\u0007NT1nKRA\u0011qTAY\u0003g\u000b)\f\u0003\u0004\u0002\u001cJ\u0001\r!\u0013\u0005\b\u0003W\u0013\u0002\u0019AAC\u0011\u001d\t9E\u0005a\u0001\u0003\u0013\"b!!/\u0002H\u0006%\u0007\u0003CA.\u0003K\nY,!1\u0011\u0007}\u000bi,C\u0002\u0002@f\u0013!$T5tg&twmQ1qC\nLG.\u001b;z\u000bb\u001cW\r\u001d;j_:\u00042!JAb\u0013\r\t)M\n\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u001cN\u0001\r!\u0013\u0005\u0007\u0003\u0017\u001c\u0002\u0019A%\u0002)I,\u0017/^5sK\u0012\u001c\u0015\r]1cS2LG/[3t\u0001")
public class JMAPApi {
    private final scala.collection.immutable.Set<Refined<String, string.Uri>> defaultCapabilities;
    private final JmapRfc8621Configuration configuration;
    private final Map<Invocation.MethodName, Method> methodsByName;

    public static Logger LOGGER() {
        return JMAPApi$.MODULE$.LOGGER();
    }

    private Map<Invocation.MethodName, Method> methodsByName() {
        return this.methodsByName;
    }

    public SMono<ResponseObject> process(RequestObject requestObject, MailboxSession mailboxSession) {
        ProcessingContext processingContext = new ProcessingContext((Map<ClientId, ServerId>)Predef$.MODULE$.Map().empty(), (Map<Invocation.MethodCallId, Invocation>)Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities = requestObject.using();
        Either validatedRequestObject = this.validateCapabilities(requestObject).flatMap((Function1 & Serializable)x$3 -> {
            RequestObject requestObject = x$3;
            return this.validateMaxCalls(requestObject).map((Function1 & Serializable)x$2 -> {
                RequestObject requestObject = x$2;
                return this.processSequentiallyAndUpdateContext(requestObject, mailboxSession, processingContext, capabilities).map((Function1 & Serializable)invocations -> new ResponseObject(ResponseObject$.MODULE$.SESSION_STATE(), (Seq<Invocation>)((Seq)invocations.map((Function1 & Serializable)x$1 -> x$1.invocation()))));
            });
        });
        return (SMono)validatedRequestObject.fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)obj -> obj);
    }

    private Either<Exception, RequestObject> validateCapabilities(RequestObject requestObject) {
        scala.collection.immutable.Set unsupportedCapabilities = (scala.collection.immutable.Set)requestObject.using().$minus$minus(this.defaultCapabilities);
        if (unsupportedCapabilities.nonEmpty()) {
            return new Left((Object)new UnsupportedCapabilitiesException((scala.collection.immutable.Set<Refined<String, string.Uri>>)unsupportedCapabilities));
        }
        return new Right((Object)requestObject);
    }

    private Either<Exception, RequestObject> validateMaxCalls(RequestObject requestObject) {
        if ((long)requestObject.methodCalls().length() > MaxCallsInRequest$.MODULE$.DEFAULT()) {
            return new Left((Object)new TooManyCallsInRequest(requestObject));
        }
        return new Right((Object)requestObject);
    }

    private SMono<Seq<InvocationWithContext>> processSequentiallyAndUpdateContext(RequestObject requestObject, MailboxSession mailboxSession, ProcessingContext processingContext, scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities) {
        return SFlux$.MODULE$.fromIterable(requestObject.methodCalls()).fold((Object)Nil$.MODULE$, (Function2 & Serializable)(acc, elem) -> {
            SMono lastProcessingContext = (SMono)acc.headOption().map((Function1 & Serializable)last -> SMono$.MODULE$.fromPublisher((Publisher)Flux.from((Publisher)last.map((Function1 & Serializable)x$4 -> x$4.processingContext())).last())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)processingContext));
            SFlux invocation = lastProcessingContext.flatMapMany((Function1 & Serializable)context -> this.process(capabilities, mailboxSession, new InvocationWithContext((Invocation)elem, (ProcessingContext)context)));
            SFlux sFlux = invocation.cache(invocation.cache$default$1(), invocation.cache$default$2());
            return acc.$colon$colon((Object)sFlux);
        }).map((Function1 & Serializable)x$5 -> x$5.reverse()).flatMap((Function1 & Serializable)list -> {
            SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)list);
            Function1 & Serializable x$1 = (Function1 & Serializable)e -> e;
            int x$2 = qual$1.concatMap$default$2();
            return qual$1.concatMap((Function1)x$1, x$2).collectSeq();
        });
    }

    private SFlux<InvocationWithContext> process(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession, InvocationWithContext invocation) {
        SFlux sFlux;
        Either<InvalidResultReferenceException, Invocation> either = invocation.processingContext().resolveBackReferences(invocation.invocation());
        if (either instanceof Left) {
            Left left = (Left)either;
            InvalidResultReferenceException e = (InvalidResultReferenceException)left.value();
            sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidResultReference$.MODULE$, "Failed resolving back-reference: " + e.message(), invocation.invocation().methodCallId()), invocation.processingContext())}));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Invocation resolvedInvocation = (Invocation)right.value();
            sFlux = this.processMethodWithMatchName(capabilities, new InvocationWithContext(resolvedInvocation, invocation.processingContext()), mailboxSession).map((Function1 & Serializable)x$6 -> x$6.recordInvocation());
        } else {
            throw new MatchError(either);
        }
        return SFlux$.MODULE$.fromPublisher((Publisher)sFlux);
    }

    private SFlux<InvocationWithContext> processMethodWithMatchName(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return ((SFluxLike)this.methodsByName().get((Object)invocation.invocation().methodName()).map((Function1 & Serializable)method -> (SFlux)this.validateCapabilities(capabilities, method.requiredCapabilities()).fold((Function1 & Serializable)e -> SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnknownMethod$.MODULE$, e.description(), invocation.invocation().methodCallId()), invocation.processingContext())})), (Function1 & Serializable)x$7 -> SFlux$.MODULE$.fromPublisher(method.process(capabilities, invocation, mailboxSession)))).getOrElse((Function0 & Serializable)() -> SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnknownMethod$.MODULE$, invocation.invocation().methodCallId()), invocation.processingContext())})))).onErrorResume((Function1 & Serializable)throwable -> SMono$.MODULE$.just((Object)new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$ServerFail$.MODULE$, throwable.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())));
    }

    private Either<MissingCapabilityException, BoxedUnit> validateCapabilities(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, scala.collection.immutable.Set<Refined<String, string.Uri>> requiredCapabilities) {
        scala.collection.immutable.Set missingCapabilities = (scala.collection.immutable.Set)requiredCapabilities.$minus$minus(capabilities).$plus$plus((IterableOnce)this.configuration.disabledCapabilities().intersect(capabilities));
        if (missingCapabilities.nonEmpty()) {
            return new Left((Object)new MissingCapabilityException("Missing capability(ies): " + missingCapabilities.mkString(", ")));
        }
        return new Right((Object)BoxedUnit.UNIT);
    }

    public JMAPApi(scala.collection.immutable.Set<Method> methods, scala.collection.immutable.Set<Refined<String, string.Uri>> defaultCapabilities, JmapRfc8621Configuration configuration) {
        this.defaultCapabilities = defaultCapabilities;
        this.configuration = configuration;
        this.methodsByName = ((IterableOnceOps)methods.map((Function1 & Serializable)method -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)method.methodName()), method))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Inject
    public JMAPApi(Set<Method> javaMethods, Set<CapabilityFactory> supportedCapabilities, JmapRfc8621Configuration configuration) {
        this((scala.collection.immutable.Set<Method>)CollectionConverters$.MODULE$.SetHasAsScala(javaMethods).asScala().toSet(), (scala.collection.immutable.Set<Refined<String, string.Uri>>)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(supportedCapabilities).asScala().map((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final String apply(CapabilityFactory x) {
                return x.id();
            }
        })).toSet(), configuration);
    }
}

