/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.file;

import java.io.FileNotFoundException;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.file.FileBlobStoreDAO;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.server.blob.deduplication.BlobStoreFactory;

public class FileBlobStoreFactory {
    private final FileSystem fileSystem;

    public FileBlobStoreFactory(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public BlobStoreFactory.RequireBlobIdFactory builder() {
        return blobIdFactory -> {
            try {
                return BlobStoreFactory.builder().blobStoreDAO((BlobStoreDAO)new FileBlobStoreDAO(this.fileSystem, blobIdFactory)).blobIdFactory(blobIdFactory);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

