/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.search;

import jakarta.inject.Inject;
import jakarta.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;

public class DeletedSearchOverride
implements ListeningMessageSearchIndex.SearchOverride {
    private final CassandraDeletedMessageDAO dao;

    @Inject
    public DeletedSearchOverride(CassandraDeletedMessageDAO dao) {
        this.dao = dao;
    }

    public boolean applicable(SearchQuery searchQuery, MailboxSession session) {
        return searchQuery.getCriteria().size() == 1 && ((SearchQuery.Criterion)searchQuery.getCriteria().get(0)).equals(SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED)) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        return this.dao.retrieveDeletedMessage((CassandraId)mailbox.getMailboxId(), MessageRange.all());
    }
}

