/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import jakarta.mail.Flags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MessageFlags {
    public static final String SEEN_OUTPUT_CAPITALISED = "\\Seen";
    public static final String RECENT_OUTPUT_CAPITALISED = "\\Recent";
    public static final String FLAGGED_OUTPUT_CAPITALISED = "\\Flagged";
    public static final String DRAFT_OUTPUT_CAPITALISED = "\\Draft";
    public static final String DELETED_OUTPUT_CAPITALISED = "\\Deleted";
    public static final String ANSWERED_OUTPUT_CAPITALISED = "\\Answered";
    public static final String USER_OUTPUT_CAPITALISED = "\\*";
    public static final Flags ALL_FLAGS = new Flags();
    public static final String ANSWERED_ALL_CAPS = "\\ANSWERED";
    public static final String DELETED_ALL_CAPS = "\\DELETED";
    public static final String DRAFT_ALL_CAPS = "\\DRAFT";
    public static final String FLAGGED_ALL_CAPS = "\\FLAGGED";
    public static final String SEEN_ALL_CAPS = "\\SEEN";
    public static final String RECENT_ALL_CAPS = "\\RECENT";

    public static Collection<String> names(Flags flags) {
        ArrayList<String> results = new ArrayList<String>();
        if (flags.contains(Flags.Flag.ANSWERED)) {
            results.add(ANSWERED_OUTPUT_CAPITALISED);
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            results.add(DELETED_OUTPUT_CAPITALISED);
        }
        if (flags.contains(Flags.Flag.DRAFT)) {
            results.add(DRAFT_OUTPUT_CAPITALISED);
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            results.add(FLAGGED_OUTPUT_CAPITALISED);
        }
        if (flags.contains(Flags.Flag.RECENT)) {
            results.add(RECENT_OUTPUT_CAPITALISED);
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            results.add(SEEN_OUTPUT_CAPITALISED);
        }
        String[] userFlags = flags.getUserFlags();
        Collections.addAll(results, userFlags);
        if (flags.contains(Flags.Flag.USER)) {
            results.add(USER_OUTPUT_CAPITALISED);
        }
        return results;
    }

    static {
        ALL_FLAGS.add(Flags.Flag.ANSWERED);
        ALL_FLAGS.add(Flags.Flag.DELETED);
        ALL_FLAGS.add(Flags.Flag.DRAFT);
        ALL_FLAGS.add(Flags.Flag.FLAGGED);
        ALL_FLAGS.add(Flags.Flag.RECENT);
        ALL_FLAGS.add(Flags.Flag.SEEN);
    }
}

