/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.message.response.AbstractListingResponse;
import org.apache.james.imap.message.response.ListResponse;
import org.apache.james.mailbox.model.MailboxMetaData;

public class ListingEncodingUtils {
    public static final byte[] NAME_CHILDINFO_EXTENDED = "\"CHILDINFO\"".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] NAME_CHILDINFO_SUBSCRIBED = "\"SUBSCRIBED\"".getBytes(StandardCharsets.US_ASCII);

    public static void encodeListingResponse(ImapCommand command, ImapResponseComposer composer, AbstractListingResponse response) throws IOException {
        composer.untagged();
        composer.message(command.getNameAsBytes());
        composer.openParen();
        for (byte[] attribute : ListingEncodingUtils.getNameAttributes(response)) {
            composer.message(attribute);
        }
        composer.closeParen();
        ListingEncodingUtils.writeDelimiter(composer, response.getHierarchyDelimiter());
        composer.mailbox(response.getName());
        if (response instanceof ListResponse) {
            ListingEncodingUtils.writeChildInfos(ListingEncodingUtils.returnChildInfosAsString(((ListResponse)response).getChildInfos()), composer);
        }
        composer.end();
    }

    private static void writeDelimiter(ImapResponseComposer composer, char hierarchyDelimiter) throws IOException {
        if (hierarchyDelimiter == '\u0000') {
            composer.nil();
        } else {
            composer.quote(hierarchyDelimiter);
        }
    }

    private static void writeChildInfos(ImmutableList<byte[]> childInfos, ImapResponseComposer composer) throws IOException {
        if (!childInfos.isEmpty()) {
            composer.openParen();
            composer.message(NAME_CHILDINFO_EXTENDED);
            composer.openParen();
            for (byte[] childInfo : childInfos) {
                composer.message(childInfo);
            }
            composer.closeParen();
            composer.closeParen();
        }
    }

    private static ImmutableList<byte[]> getNameAttributes(AbstractListingResponse response) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListingEncodingUtils.selectabilityAsString(response.getSelectability(), (ImmutableList.Builder<byte[]>)builder);
        ListingEncodingUtils.childrenAsString(response.getChildren(), (ImmutableList.Builder<byte[]>)builder);
        ListingEncodingUtils.mailboxAttributeAsString(response.getTypeAsString(), (ImmutableList.Builder<byte[]>)builder);
        if (response instanceof ListResponse) {
            ListResponse listResponse = (ListResponse)response;
            ListingEncodingUtils.returnSubscribedAsString(listResponse.isReturnSubscribed(), (ImmutableList.Builder<byte[]>)builder);
            ListingEncodingUtils.returnNonExistentAsString(listResponse.isReturnNonExistent(), (ImmutableList.Builder<byte[]>)builder);
        }
        return builder.build();
    }

    private static ImmutableList.Builder<byte[]> selectabilityAsString(MailboxMetaData.Selectability selectability, ImmutableList.Builder<byte[]> builder) {
        switch (selectability) {
            case MARKED: {
                return builder.add((Object)ImapConstants.NAME_ATTRIBUTE_MARKED);
            }
            case NOSELECT: {
                return builder.add((Object)ImapConstants.NAME_ATTRIBUTE_NOSELECT);
            }
            case UNMARKED: {
                return builder.add((Object)ImapConstants.NAME_ATTRIBUTE_UNMARKED);
            }
        }
        return builder;
    }

    private static ImmutableList.Builder<byte[]> childrenAsString(MailboxMetaData.Children children, ImmutableList.Builder<byte[]> builder) {
        switch (children) {
            case HAS_CHILDREN: {
                return builder.add((Object)ImapConstants.NAME_ATTRIBUTE_HAS_CHILDREN);
            }
            case HAS_NO_CHILDREN: {
                return builder.add((Object)ImapConstants.NAME_ATTRIBUTE_HAS_NO_CHILDREN);
            }
            case NO_INFERIORS: {
                return builder.add((Object)ImapConstants.NAME_ATTRIBUTE_NOINFERIORS);
            }
        }
        return builder;
    }

    private static ImmutableList.Builder<byte[]> mailboxAttributeAsString(String attributeName, ImmutableList.Builder<byte[]> builder) {
        if (attributeName != null) {
            return builder.add((Object)attributeName.getBytes(StandardCharsets.US_ASCII));
        }
        return builder;
    }

    private static ImmutableList.Builder<byte[]> returnSubscribedAsString(boolean returnSubscribed, ImmutableList.Builder<byte[]> builder) {
        if (returnSubscribed) {
            return builder.add((Object)ImapConstants.NAME_ATTRIBUTE_SUBSCRIBED);
        }
        return builder;
    }

    private static ImmutableList.Builder<byte[]> returnNonExistentAsString(boolean returnNonExistent, ImmutableList.Builder<byte[]> builder) {
        if (returnNonExistent) {
            return builder.add((Object)ImapConstants.NAME_ATTRIBUTE_NON_EXISTENT);
        }
        return builder;
    }

    private static ImmutableList<byte[]> returnChildInfosAsString(EnumSet<ListResponse.ChildInfo> childInfos) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (childInfos != null && !childInfos.isEmpty()) {
            childInfos.forEach(childInfo -> {
                if (childInfo == ListResponse.ChildInfo.SUBSCRIBED) {
                    builder.add((Object)NAME_CHILDINFO_SUBSCRIBED);
                }
            });
        }
        return builder.build();
    }
}

