/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class BucketName {
    public static final BucketName DEFAULT = BucketName.of("default");
    private final String value;

    public static BucketName of(String value) {
        return new BucketName(value);
    }

    private BucketName(String value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"`value` cannot be blank");
        this.value = value;
    }

    public String asString() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof BucketName) {
            BucketName that = (BucketName)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

