/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Disposable;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.server.core.Envelope;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageVaultHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeletedMessageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletedMessageConverter.class);

    DeletedMessageConverter() {
    }

    DeletedMessage convert(DeletedMessageVaultHook.DeletedMessageMailboxContext deletedMessageMailboxContext, Message message, ZonedDateTime deletionDate) throws IOException {
        Preconditions.checkNotNull((Object)deletedMessageMailboxContext);
        Preconditions.checkNotNull((Object)message);
        Optional<org.apache.james.mime4j.dom.Message> mimeMessage = this.parseMessage(message);
        DeletedMessage deletedMessage = ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId(deletedMessageMailboxContext.getMessageId())).originMailboxes(deletedMessageMailboxContext.getOwnerMailboxes())).user(this.retrieveOwner(deletedMessageMailboxContext))).deliveryDate(this.retrieveDeliveryDate(mimeMessage, message))).deletionDate(deletionDate)).sender(this.retrieveSender(mimeMessage))).recipients(this.retrieveRecipients(mimeMessage))).hasAttachment(!message.getAttachments().isEmpty())).size(message.getFullContentOctets())).subject(mimeMessage.map(org.apache.james.mime4j.dom.Message::getSubject)).build();
        mimeMessage.ifPresent(Disposable::dispose);
        return deletedMessage;
    }

    private Optional<org.apache.james.mime4j.dom.Message> parseMessage(Message message) throws IOException {
        DefaultMessageBuilder messageBuilder = new DefaultMessageBuilder();
        messageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        messageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        try {
            return Optional.ofNullable(messageBuilder.parseMessage(message.getFullContent()));
        }
        catch (MimeIOException e) {
            LOGGER.warn("Can not parse the message {}", (Object)message.getMessageId(), (Object)e);
            return Optional.empty();
        }
    }

    private Username retrieveOwner(DeletedMessageVaultHook.DeletedMessageMailboxContext deletedMessageMailboxContext) {
        Preconditions.checkNotNull((Object)deletedMessageMailboxContext.getOwner(), (Object)"Deleted mail is missing owner");
        return deletedMessageMailboxContext.getOwner();
    }

    private ZonedDateTime retrieveDeliveryDate(Optional<org.apache.james.mime4j.dom.Message> mimeMessage, Message message) {
        return mimeMessage.map(org.apache.james.mime4j.dom.Message::getDate).map(Date::toInstant).map(instant -> ZonedDateTime.ofInstant(instant, ZoneOffset.UTC)).orElse(ZonedDateTime.ofInstant(message.getInternalDate().toInstant(), ZoneOffset.UTC));
    }

    private MaybeSender retrieveSender(Optional<org.apache.james.mime4j.dom.Message> mimeMessage) {
        return mimeMessage.map(org.apache.james.mime4j.dom.Message::getSender).map(Mailbox::getAddress).map(MaybeSender::getMailSender).orElse(MaybeSender.nullSender());
    }

    private Set<MailAddress> retrieveRecipients(Optional<org.apache.james.mime4j.dom.Message> maybeMessage) {
        return maybeMessage.map(message -> Envelope.fromMime4JMessage((org.apache.james.mime4j.dom.Message)message, (Envelope.ValidationPolicy)Envelope.ValidationPolicy.IGNORE)).map(Envelope::getRecipients).orElse((Set)ImmutableSet.of());
    }
}

