/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultGeometry;
import com.datastax.dse.driver.internal.core.data.geometry.WkbSerializationProxy;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultLineString
extends DefaultGeometry
implements LineString {
    private static final long serialVersionUID = 1280189361978382248L;
    private final List<Point> points;

    private static OGCLineString fromPoints(Point p1, Point p2, Point ... pn) {
        Polyline polyline = new Polyline(DefaultLineString.toEsri(p1), DefaultLineString.toEsri(p2));
        for (Point p : pn) {
            polyline.lineTo(DefaultLineString.toEsri(p));
        }
        return new OGCLineString((MultiPath)polyline, 0, DefaultGeometry.SPATIAL_REFERENCE_4326);
    }

    public DefaultLineString(@NonNull Point p1, @NonNull Point p2, Point ... pn) {
        super((OGCGeometry)DefaultLineString.fromPoints(p1, p2, pn));
        this.points = ImmutableList.builder().add((Object)p1).add((Object)p2).add((Object[])pn).build();
    }

    public DefaultLineString(@NonNull OGCLineString lineString) {
        super((OGCGeometry)lineString);
        this.points = DefaultLineString.getPoints(lineString);
    }

    @Override
    @NonNull
    public List<Point> getPoints() {
        return this.points;
    }

    private Object writeReplace() {
        return new WkbSerializationProxy(this.asWellKnownBinary());
    }
}

