/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.config;

import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.OptionsMap;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.config.composite.CompositeDriverConfigLoader;
import com.datastax.oss.driver.internal.core.config.map.MapBasedDriverConfigLoader;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.CompletionStage;

public interface DriverConfigLoader
extends AutoCloseable {
    @NonNull
    public static DriverConfigLoader fromDefaults(@NonNull ClassLoader appClassLoader) {
        return new DefaultDriverConfigLoader(appClassLoader);
    }

    @NonNull
    public static DriverConfigLoader fromClasspath(@NonNull String resourceBaseName) {
        return DriverConfigLoader.fromClasspath(resourceBaseName, Thread.currentThread().getContextClassLoader());
    }

    @NonNull
    public static DriverConfigLoader fromClasspath(@NonNull String resourceBaseName, @NonNull ClassLoader appClassLoader) {
        return DefaultDriverConfigLoader.fromClasspath(resourceBaseName, appClassLoader);
    }

    @NonNull
    public static DriverConfigLoader fromPath(@NonNull Path file) {
        return DriverConfigLoader.fromFile(file.toFile());
    }

    @NonNull
    public static DriverConfigLoader fromFile(@NonNull File file) {
        return DefaultDriverConfigLoader.fromFile(file);
    }

    @NonNull
    public static DriverConfigLoader fromUrl(@NonNull URL url) {
        return DefaultDriverConfigLoader.fromUrl(url);
    }

    @NonNull
    public static DriverConfigLoader fromString(@NonNull String contents) {
        return DefaultDriverConfigLoader.fromString(contents);
    }

    @NonNull
    public static ProgrammaticDriverConfigLoaderBuilder programmaticBuilder() {
        return new DefaultProgrammaticDriverConfigLoaderBuilder();
    }

    @NonNull
    public static ProgrammaticDriverConfigLoaderBuilder programmaticBuilder(@NonNull ClassLoader appClassLoader) {
        return new DefaultProgrammaticDriverConfigLoaderBuilder(appClassLoader);
    }

    @NonNull
    public static DriverConfigLoader fromMap(@NonNull OptionsMap source) {
        return new MapBasedDriverConfigLoader(source, source.asRawMap());
    }

    @NonNull
    public static DriverConfigLoader compose(@NonNull DriverConfigLoader primaryConfigLoader, @NonNull DriverConfigLoader fallbackConfigLoader) {
        return new CompositeDriverConfigLoader(primaryConfigLoader, fallbackConfigLoader);
    }

    @NonNull
    public DriverConfig getInitialConfig();

    public void onDriverInit(@NonNull DriverContext var1);

    @NonNull
    public CompletionStage<Boolean> reload();

    public boolean supportsReloading();

    @Override
    public void close();
}

