/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.theta;

import org.apache.pulsar.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.memory.NativeMemory;
import org.apache.pulsar.shade.com.yahoo.sketches.Util;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.CompactSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.PreambleUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.UpdateSketch;

final class HeapCompactOrderedSketch
extends CompactSketch {
    private final long[] cache_;

    private HeapCompactOrderedSketch(boolean empty, short seedHash, int curCount, long thetaLong, long[] cache) {
        super(empty, seedHash, curCount, thetaLong);
        this.cache_ = cache;
    }

    static HeapCompactOrderedSketch heapifyInstance(Memory srcMem, long seed) {
        long pre0 = srcMem.getLong(0L);
        int preLongs = PreambleUtil.extractPreLongs(pre0);
        int flags = PreambleUtil.extractFlags(pre0);
        boolean empty = (flags & 4) > 0;
        short memSeedHash = (short)PreambleUtil.extractSeedHash(pre0);
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        int curCount = preLongs > 1 ? srcMem.getInt(8L) : 0;
        long thetaLong = preLongs > 2 ? srcMem.getLong(16L) : Long.MAX_VALUE;
        long[] cacheArr = new long[curCount];
        if (curCount > 0) {
            srcMem.getLongArray(preLongs << 3, cacheArr, 0, curCount);
        }
        HeapCompactOrderedSketch hcs = new HeapCompactOrderedSketch(empty, memSeedHash, curCount, thetaLong, cacheArr);
        return hcs;
    }

    HeapCompactOrderedSketch(UpdateSketch sketch) {
        super(sketch.isEmpty(), sketch.getSeedHash(), sketch.getRetainedEntries(true), sketch.getThetaLong());
        boolean ordered = true;
        this.cache_ = CompactSketch.compactCache(sketch.getCache(), this.getRetainedEntries(false), this.getThetaLong(), true);
    }

    HeapCompactOrderedSketch(long[] compactOrderedCache, boolean empty, short seedHash, int curCount, long thetaLong) {
        super(empty, seedHash, curCount, thetaLong);
        assert (compactOrderedCache != null);
        this.cache_ = curCount == 0 ? new long[]{} : compactOrderedCache;
    }

    @Override
    public byte[] toByteArray() {
        byte[] byteArray = new byte[this.getCurrentBytes(true)];
        NativeMemory dstMem = new NativeMemory(byteArray);
        int emptyBit = this.isEmpty() ? 4 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | 0x10);
        HeapCompactOrderedSketch.loadCompactMemory(this.getCache(), this.isEmpty(), this.getSeedHash(), this.getRetainedEntries(true), this.getThetaLong(), dstMem, flags);
        return byteArray;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

