/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.data.jmap.EmailQueryViewPopulator;
import org.apache.james.webadmin.data.jmap.RunningOptions;
import org.apache.james.webadmin.data.jmap.RunningOptionsDTO;

public class PopulateEmailQueryViewTask
implements Task {
    static final TaskType TASK_TYPE = TaskType.of((String)"PopulateEmailQueryViewTask");
    private final EmailQueryViewPopulator populator;
    private final EmailQueryViewPopulator.Progress progress;
    private final RunningOptions runningOptions;

    public static TaskDTOModule<PopulateEmailQueryViewTask, PopulateEmailQueryViewTaskDTO> module(EmailQueryViewPopulator populator) {
        return (TaskDTOModule)DTOModule.forDomainObject(PopulateEmailQueryViewTask.class).convertToDTO(PopulateEmailQueryViewTaskDTO.class).toDomainObjectConverter(dto -> PopulateEmailQueryViewTask.asTask(populator, dto)).toDTOConverter(PopulateEmailQueryViewTask::asDTO).typeName(TASK_TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    private static PopulateEmailQueryViewTaskDTO asDTO(PopulateEmailQueryViewTask task, String type) {
        return new PopulateEmailQueryViewTaskDTO(type, Optional.of(RunningOptionsDTO.asDTO(task.runningOptions)));
    }

    private static PopulateEmailQueryViewTask asTask(EmailQueryViewPopulator populator, PopulateEmailQueryViewTaskDTO dto) {
        return new PopulateEmailQueryViewTask(populator, dto.getRunningOptions().map(RunningOptionsDTO::asDomainObject).orElse(RunningOptions.DEFAULT));
    }

    PopulateEmailQueryViewTask(EmailQueryViewPopulator populator, RunningOptions runningOptions) {
        this.populator = populator;
        this.runningOptions = runningOptions;
        this.progress = new EmailQueryViewPopulator.Progress();
    }

    public Task.Result run() {
        return (Task.Result)this.populator.populateView(this.progress, this.runningOptions).block();
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.progress, this.runningOptions));
    }

    public static class PopulateEmailQueryViewTaskDTO
    implements TaskDTO {
        private final String type;
        private final Optional<RunningOptionsDTO> runningOptions;

        public PopulateEmailQueryViewTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
            this.type = type;
            this.runningOptions = runningOptions;
        }

        public String getType() {
            return this.type;
        }

        public Optional<RunningOptionsDTO> getRunningOptions() {
            return this.runningOptions;
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final RunningOptions runningOptions;
        private final long processedUserCount;
        private final long processedMessageCount;
        private final long failedUserCount;
        private final long failedMessageCount;
        private final Instant timestamp;

        private static AdditionalInformation from(EmailQueryViewPopulator.Progress progress, RunningOptions runningOptions) {
            return new AdditionalInformation(runningOptions, progress.getProcessedUserCount(), progress.getProcessedMessageCount(), progress.getFailedUserCount(), progress.getFailedMessageCount(), Clock.systemUTC().instant());
        }

        public AdditionalInformation(RunningOptions runningOptions, long processedUserCount, long processedMessageCount, long failedUserCount, long failedMessageCount, Instant timestamp) {
            this.runningOptions = runningOptions;
            this.processedUserCount = processedUserCount;
            this.processedMessageCount = processedMessageCount;
            this.failedUserCount = failedUserCount;
            this.failedMessageCount = failedMessageCount;
            this.timestamp = timestamp;
        }

        public long getProcessedUserCount() {
            return this.processedUserCount;
        }

        public long getProcessedMessageCount() {
            return this.processedMessageCount;
        }

        public long getFailedUserCount() {
            return this.failedUserCount;
        }

        public long getFailedMessageCount() {
            return this.failedMessageCount;
        }

        public RunningOptions getRunningOptions() {
            return this.runningOptions;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

