/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.core.Username;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UsernameChangeService {
    private final Set<UsernameChangeTaskStep> steps;

    @Inject
    public UsernameChangeService(Set<UsernameChangeTaskStep> steps) {
        this.steps = steps;
    }

    public Performer performer(Optional<UsernameChangeTaskStep.StepName> fromStep) {
        return new Performer(this.steps, new UsernameChangeStatus(this.steps), fromStep);
    }

    public static class Performer {
        private final Set<UsernameChangeTaskStep> steps;
        private final UsernameChangeStatus status;
        private final Optional<Integer> correspondingPriority;

        public Performer(Set<UsernameChangeTaskStep> steps, UsernameChangeStatus status, Optional<UsernameChangeTaskStep.StepName> fromStep) {
            this.steps = steps;
            this.status = status;
            this.correspondingPriority = fromStep.map(this::correspondingPriority);
        }

        public Mono<Void> changeUsername(Username oldUsername, Username newUsername) {
            this.correspondingPriority.ifPresent(priority -> this.steps.stream().filter(step -> step.priority() < priority).forEach(step -> this.status.skipStep(step.name())));
            return this.steps().concatMap(step -> Mono.fromRunnable(() -> this.status.beginStep(step.name())).then(Mono.from((Publisher)step.changeUsername(oldUsername, newUsername))).then(Mono.fromRunnable(() -> this.status.endStep(step.name()))).doOnError(e -> this.status.failedStep(step.name()))).doOnError(e -> this.status.abort()).then();
        }

        private Flux<UsernameChangeTaskStep> steps() {
            return this.correspondingPriority.map(priority -> Flux.fromIterable(this.steps).filter(step -> step.priority() >= priority).sort(Comparator.comparingInt(UsernameChangeTaskStep::priority))).orElseGet(() -> Flux.fromIterable(this.steps).sort(Comparator.comparingInt(UsernameChangeTaskStep::priority)));
        }

        private int correspondingPriority(UsernameChangeTaskStep.StepName stepName) {
            return this.steps.stream().filter(step -> step.name().equals((Object)stepName)).map(UsernameChangeTaskStep::priority).findAny().orElseThrow(() -> new IllegalArgumentException("Starting step not found: " + stepName.asString()));
        }

        public UsernameChangeStatus getStatus() {
            return this.status;
        }
    }

    public static class UsernameChangeStatus {
        private final Map<UsernameChangeTaskStep.StepName, StepState> states;

        public UsernameChangeStatus(Set<UsernameChangeTaskStep> steps) {
            this.states = new ConcurrentHashMap<UsernameChangeTaskStep.StepName, StepState>((Map)steps.stream().collect(ImmutableMap.toImmutableMap(UsernameChangeTaskStep::name, any -> StepState.WAITING)));
        }

        public void beginStep(UsernameChangeTaskStep.StepName step) {
            this.states.put(step, StepState.IN_PROGRESS);
        }

        public void endStep(UsernameChangeTaskStep.StepName step) {
            this.states.put(step, StepState.DONE);
        }

        public void failedStep(UsernameChangeTaskStep.StepName step) {
            this.states.put(step, StepState.FAILED);
        }

        public void abortStep(UsernameChangeTaskStep.StepName step) {
            this.states.put(step, StepState.ABORTED);
        }

        public void skipStep(UsernameChangeTaskStep.StepName step) {
            this.states.put(step, StepState.SKIPPED);
        }

        public void abort() {
            this.states.entrySet().stream().filter(entry -> entry.getValue() == StepState.WAITING || entry.getValue() == StepState.IN_PROGRESS).forEach(entry -> this.abortStep((UsernameChangeTaskStep.StepName)entry.getKey()));
        }

        public Map<UsernameChangeTaskStep.StepName, StepState> getStates() {
            return ImmutableMap.copyOf(this.states);
        }
    }

    public static enum StepState {
        WAITING,
        IN_PROGRESS,
        DONE,
        FAILED,
        ABORTED,
        SKIPPED;

    }
}

