/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import jakarta.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.rrt.api.LoopDetectedException;
import org.apache.james.rrt.api.MappingAlreadyExistsException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SameSourceAndDestinationException;
import org.apache.james.rrt.api.SourceDomainIsNotInDomainListException;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.MailAddressParser;
import org.apache.james.webadmin.utils.ErrorResponder;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.Service;
import spark.Spark;

public class AddressMappingRoutes
implements Routes {
    static final String BASE_PATH = "/mappings/address/";
    static final String ADDRESS_MAPPING_PATH = "/mappings/address/:mappingSource/targets/:destinationAddress";
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    AddressMappingRoutes(RecipientRewriteTable recipientRewriteTable) {
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        service.post(ADDRESS_MAPPING_PATH, this::addAddressMapping);
        service.delete(ADDRESS_MAPPING_PATH, this::removeAddressMapping);
    }

    public HaltException addAddressMapping(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress source = MailAddressParser.parseMailAddress(request.params("mappingSource"), "address");
        MailAddress destinationAddress = MailAddressParser.parseMailAddress(request.params("destinationAddress"), "address");
        this.addAddressMapping(MappingSource.fromMailAddress((MailAddress)source), destinationAddress);
        return Spark.halt((int)204);
    }

    private void addAddressMapping(MappingSource source, MailAddress destination) throws RecipientRewriteTableException {
        try {
            this.recipientRewriteTable.addAddressMapping(source, destination.asString());
        }
        catch (MappingAlreadyExistsException mappingAlreadyExistsException) {
        }
        catch (SameSourceAndDestinationException | SourceDomainIsNotInDomainListException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(e.getMessage()).haltError();
        }
        catch (LoopDetectedException e) {
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.WRONG_STATE).message(e.getMessage()).haltError();
        }
    }

    public HaltException removeAddressMapping(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress source = MailAddressParser.parseMailAddress(request.params("mappingSource"), "address");
        MailAddress destinationAddress = MailAddressParser.parseMailAddress(request.params("destinationAddress"), "address");
        this.removeAddressMapping(MappingSource.fromMailAddress((MailAddress)source), destinationAddress);
        return Spark.halt((int)204);
    }

    private void removeAddressMapping(MappingSource source, MailAddress destination) throws RecipientRewriteTableException {
        this.recipientRewriteTable.removeAddressMapping(source, destination.asString());
    }
}

