/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.github.fge.lambdas.Throwing;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.MappingsModule;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

public class MappingRoutes
implements Routes {
    static final String BASE_PATH = "/mappings";
    static final String USER_MAPPING_PATH = "/mappings/user/";
    static final String SOURCE_MAPPING_PATH = "/mappings/sources/";
    static final String USER = "user";
    static final String SOURCE = "source";
    private final JsonTransformer jsonTransformer;
    private final JsonExtractor<Map<MappingSource, Mappings>> jsonExtractor;
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    MappingRoutes(JsonTransformer jsonTransformer, RecipientRewriteTable recipientRewriteTable) {
        this.jsonTransformer = jsonTransformer;
        TypeReference<Map<MappingSource, Mappings>> typeRef = new TypeReference<Map<MappingSource, Mappings>>(this){};
        this.jsonExtractor = new JsonExtractor((TypeReference)typeRef, new Module[]{new MappingsModule().asJacksonModule()});
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        service.get(BASE_PATH, this::getMappings, (ResponseTransformer)this.jsonTransformer);
        service.put(BASE_PATH, this::addMappings);
        service.get("/mappings/user/:user", this::getUserMappings, (ResponseTransformer)this.jsonTransformer);
        service.get("/mappings/sources/:source", this::getMappingSources, (ResponseTransformer)this.jsonTransformer);
        service.delete("/mappings/sources/:source", this::deleteMappingSources, (ResponseTransformer)this.jsonTransformer);
    }

    private Map<MappingSource, Mappings> getMappings(Request request, Response response) {
        try {
            return this.recipientRewriteTable.getAllMappings();
        }
        catch (RecipientRewriteTableException e) {
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(e.getMessage()).haltError();
        }
    }

    public String addMappings(Request request, Response response) {
        try {
            Map mappings = (Map)this.jsonExtractor.parse(request.body());
            for (Map.Entry entry : mappings.entrySet()) {
                for (Mapping mapping : (Mappings)entry.getValue()) {
                    this.recipientRewriteTable.addMapping((MappingSource)entry.getKey(), mapping);
                }
            }
            return Responses.returnNoContent((Response)response);
        }
        catch (JsonExtractException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("error parsing mappings").cause((Exception)((Object)e)).haltError();
        }
        catch (RecipientRewriteTableException e) {
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("error adding mappings").cause((Exception)((Object)e)).haltError();
        }
    }

    private Mappings getUserMappings(Request request, Response response) throws RecipientRewriteTableException {
        Username username = Username.of((String)request.params(USER).toLowerCase());
        return this.recipientRewriteTable.getStoredMappings(MappingSource.fromUser((Username)username));
    }

    private List<String> getMappingSources(Request request, Response response) {
        Mapping mapping = Mapping.of((Mapping.Type)MappingRoutes.extractType(request), (String)request.params(SOURCE));
        return (List)this.recipientRewriteTable.listSourcesReactive(mapping).map(MappingSource::asMailAddressString).collectList().block();
    }

    private HaltException deleteMappingSources(Request request, Response response) {
        Mapping mapping = Mapping.of((Mapping.Type)MappingRoutes.extractType(request), (String)request.params(SOURCE));
        ((List)this.recipientRewriteTable.listSourcesReactive(mapping).collectList().block()).forEach(Throwing.consumer(source -> this.recipientRewriteTable.removeMapping(source, mapping)));
        return Spark.halt((int)204);
    }

    private static Mapping.Type extractType(Request request) {
        return Optional.ofNullable(request.queryParams("type")).map(name -> Arrays.stream(Mapping.Type.values()).filter(v -> v.name().equalsIgnoreCase((String)name)).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid 'type' query parameter: " + name))).orElseThrow(() -> new IllegalArgumentException("On reversed resolution 'type' is compulsory"));
    }
}

