/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.ManageableMailQueue;

public class MailQueueDTO {
    private final String name;
    private final long size;

    public static Builder builder() {
        return new Builder();
    }

    public static MailQueueDTO from(ManageableMailQueue mailQueue) throws MailQueue.MailQueueException {
        return MailQueueDTO.builder().name(mailQueue.getName().asString()).size(mailQueue.getSize()).build();
    }

    private MailQueueDTO(String name, long size) {
        this.name = name;
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public static class Builder {
        private String name;
        private long size;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public MailQueueDTO build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"name is mandatory");
            return new MailQueueDTO(this.name, this.size);
        }
    }
}

