/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PopulateComposedAttributeValuesTask
extends Task {
    @NotNull
    static final String POPULATE_COMPOSED_ATTRIBUTE_VALUES_TASK_CLASS = "com.unboundid.directory.server.tasks.PopulateComposedAttributeValuesTask";
    @NotNull
    private static final String ATTR_BACKEND_ID = "ds-task-populate-composed-attribute-backend-id";
    @NotNull
    private static final String ATTR_MAX_RATE_PER_SECOND = "ds-task-populate-composed-attribute-max-rate-per-second";
    @NotNull
    private static final String ATTR_PLUGIN_CONFIG = "ds-task-populate-composed-attribute-plugin-config";
    @NotNull
    private static final String OC_POPULATE_COMPOSED_ATTRIBUTE_VALUES_TASK = "ds-task-populate-composed-attribute";
    @NotNull
    private static final TaskProperty PROPERTY_BACKEND_ID = new TaskProperty("ds-task-populate-composed-attribute-backend-id", TaskMessages.INFO_POPULATE_COMPOSED_ATTR_DISPLAY_NAME_BACKEND_ID.get(), TaskMessages.INFO_POPULATE_COMPOSED_ATTR_DESCRIPTION_BACKEND_ID.get(), String.class, false, true, false);
    @NotNull
    private static final TaskProperty PROPERTY_MAX_RATE_PER_SECOND = new TaskProperty("ds-task-populate-composed-attribute-max-rate-per-second", TaskMessages.INFO_POPULATE_COMPOSED_ATTR_DISPLAY_NAME_MAX_RATE.get(), TaskMessages.INFO_POPULATE_COMPOSED_ATTR_DESCRIPTION_MAX_RATE.get(), Long.class, false, false, false);
    @NotNull
    private static final TaskProperty PROPERTY_PLUGIN_CONFIG = new TaskProperty("ds-task-populate-composed-attribute-plugin-config", TaskMessages.INFO_POPULATE_COMPOSED_ATTR_DISPLAY_NAME_PLUGIN_CONFIG.get(), TaskMessages.INFO_POPULATE_COMPOSED_ATTR_DESCRIPTION_PLUGIN_CONFIG.get(), String.class, false, true, false);
    private static final long serialVersionUID = 5225591249266743619L;
    @Nullable
    private final Integer maxRatePerSecond;
    @NotNull
    private final List<String> backendIDs;
    @NotNull
    private final List<String> pluginConfigs;

    public PopulateComposedAttributeValuesTask() {
        this.maxRatePerSecond = null;
        this.backendIDs = null;
        this.pluginConfigs = null;
    }

    public PopulateComposedAttributeValuesTask(@Nullable String taskID, @Nullable List<String> pluginConfigs, @Nullable List<String> backendIDs, @Nullable Integer maxRatePerSecond) {
        this(taskID, pluginConfigs, backendIDs, maxRatePerSecond, null, null, null, null, null, null, null, null, null, null);
    }

    public PopulateComposedAttributeValuesTask(@Nullable String taskID, @Nullable List<String> pluginConfigs, @Nullable List<String> backendIDs, @Nullable Integer maxRatePerSecond, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, POPULATE_COMPOSED_ATTRIBUTE_VALUES_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        this.pluginConfigs = pluginConfigs == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(pluginConfigs));
        this.backendIDs = backendIDs == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(backendIDs));
        this.maxRatePerSecond = maxRatePerSecond;
    }

    public PopulateComposedAttributeValuesTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        String[] configs = entry.getAttributeValues(ATTR_PLUGIN_CONFIG);
        this.pluginConfigs = configs == null || configs.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(configs));
        String[] ids = entry.getAttributeValues(ATTR_BACKEND_ID);
        this.backendIDs = ids == null || ids.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(ids));
        this.maxRatePerSecond = entry.getAttributeValueAsInteger(ATTR_MAX_RATE_PER_SECOND);
    }

    public PopulateComposedAttributeValuesTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(POPULATE_COMPOSED_ATTRIBUTE_VALUES_TASK_CLASS, properties);
        Integer maxRate = null;
        ArrayList<String> configs = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            Long l;
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_PLUGIN_CONFIG)) {
                String[] parsedConfigs = PopulateComposedAttributeValuesTask.parseStrings(p, values, StaticUtils.NO_STRINGS);
                if (parsedConfigs == null || parsedConfigs.length <= 0) continue;
                configs.addAll(Arrays.asList(parsedConfigs));
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_BACKEND_ID)) {
                String[] parsedIDs = PopulateComposedAttributeValuesTask.parseStrings(p, values, StaticUtils.NO_STRINGS);
                if (parsedIDs == null || parsedIDs.length <= 0) continue;
                ids.addAll(Arrays.asList(parsedIDs));
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_MAX_RATE_PER_SECOND) || (l = PopulateComposedAttributeValuesTask.parseLong(p, values, null)) == null) continue;
            maxRate = l.intValue();
        }
        this.pluginConfigs = Collections.unmodifiableList(configs);
        this.backendIDs = Collections.unmodifiableList(ids);
        this.maxRatePerSecond = maxRate;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_POPULATE_COMPOSED_ATTR_VALUES.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_POPULATE_COMPOSED_ATTR_VALUES.get();
    }

    @NotNull
    public List<String> getPluginConfigs() {
        return this.pluginConfigs;
    }

    @NotNull
    public List<String> getBackendIDs() {
        return this.backendIDs;
    }

    @Nullable
    public Integer getMaxRatePerSecond() {
        return this.maxRatePerSecond;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_POPULATE_COMPOSED_ATTRIBUTE_VALUES_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(3);
        if (!this.pluginConfigs.isEmpty()) {
            attrList.add(new Attribute(ATTR_PLUGIN_CONFIG, this.pluginConfigs));
        }
        if (!this.backendIDs.isEmpty()) {
            attrList.add(new Attribute(ATTR_BACKEND_ID, this.backendIDs));
        }
        if (this.maxRatePerSecond != null) {
            attrList.add(new Attribute(ATTR_MAX_RATE_PER_SECOND, String.valueOf(this.maxRatePerSecond)));
        }
        return Collections.unmodifiableList(attrList);
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_PLUGIN_CONFIG, PROPERTY_BACKEND_ID, PROPERTY_MAX_RATE_PER_SECOND));
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(10));
        props.put(PROPERTY_PLUGIN_CONFIG, Collections.unmodifiableList(this.pluginConfigs));
        props.put(PROPERTY_BACKEND_ID, Collections.unmodifiableList(this.backendIDs));
        if (this.maxRatePerSecond != null) {
            props.put(PROPERTY_MAX_RATE_PER_SECOND, Collections.singletonList(this.maxRatePerSecond.longValue()));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

