/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.priority;

import java.util.Optional;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.smtpserver.priority.SmtpMtPriorityParameterHook;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;

public class SmtpMtPriorityMessageHook
implements JamesMessageHook {
    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        Optional priority = session.getAttachment(SmtpMtPriorityParameterHook.MT_PRIORITY_ATTACHMENT_KEY, ProtocolSession.State.Transaction);
        priority.ifPresent(value -> mail.setAttribute(this.toMailPrioritySupportAttributeValue((Integer)value)));
        return HookResult.DECLINED;
    }

    private Attribute toMailPrioritySupportAttributeValue(Integer priorityValue) {
        if (priorityValue < -9) {
            return new Attribute(MailPrioritySupport.MAIL_PRIORITY, AttributeValue.of((Integer)-9));
        }
        return new Attribute(MailPrioritySupport.MAIL_PRIORITY, AttributeValue.of((Integer)priorityValue));
    }
}

