/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TupleFilter;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.shared.common.error.StandardException;

public class DropDependencyFilter
implements TupleFilter {
    UUID providerID;
    UUIDFactory uuidFactory = null;
    DataValueFactory dataValueFactory = null;
    BooleanDataValue trueValue;
    BooleanDataValue falseValue;

    public DropDependencyFilter(UUID uUID) {
        this.providerID = uUID;
    }

    @Override
    public void init(ExecRow execRow) throws StandardException {
    }

    @Override
    public BooleanDataValue execute(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(3);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        if (this.providerID.equals(uUID)) {
            return this.getTrueValue();
        }
        return this.getFalseValue();
    }

    private UUIDFactory getUUIDFactory() throws StandardException {
        if (this.uuidFactory == null) {
            this.uuidFactory = DataDictionaryImpl.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory;
    }

    private BooleanDataValue getTrueValue() throws StandardException {
        if (this.trueValue == null) {
            this.trueValue = new SQLBoolean(true);
        }
        return this.trueValue;
    }

    private BooleanDataValue getFalseValue() throws StandardException {
        if (this.falseValue == null) {
            this.falseValue = new SQLBoolean(false);
        }
        return this.falseValue;
    }
}

