/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.jooq.exception.ConfigurationException;
import org.jooq.impl.AnnotatedPojoMemberProvider;
import org.jooq.impl.ThrowingPredicate;
import org.jooq.impl.Tools;

final class LegacyAnnotatedPojoMemberProvider
implements AnnotatedPojoMemberProvider {
    LegacyAnnotatedPojoMemberProvider() {
    }

    @Override
    public List<Field> getMembers(Class<?> type, String name) {
        return Collections.emptyList();
    }

    @Override
    public List<Method> getGetters(Class<?> type, String name) {
        return Collections.emptyList();
    }

    @Override
    public List<Method> getSetters(Class<?> type, String name) {
        return Collections.emptyList();
    }

    @Override
    public boolean hasAnnotations(Class<?> type) {
        if (LegacyAnnotatedPojoMemberProvider.hasPersistenceAnnotations().test(type) || Tools.anyMatch(type.getMethods(), LegacyAnnotatedPojoMemberProvider.hasPersistenceAnnotations()) || Tools.anyMatch(type.getDeclaredMethods(), LegacyAnnotatedPojoMemberProvider.hasPersistenceAnnotations()) || Tools.anyMatch(type.getFields(), LegacyAnnotatedPojoMemberProvider.hasPersistenceAnnotations()) || Tools.anyMatch(type.getDeclaredFields(), LegacyAnnotatedPojoMemberProvider.hasPersistenceAnnotations())) {
            throw new ConfigurationException("No explicit AnnotatedPojoMemberProvider is configured.\n\nJakarta Persistence annotations are present on POJO {pojo}\nwithout any explicit AnnotatedPojoMemberProvider configuration.\n\nStarting from jOOQ 3.20, the Configuration.annotatedPojoMemberProvider() SPI is required for the\nDefaultRecordMapper to map a Record to a POJO that is annotated with Jakarta Persistence annotations.\nThis LegacyAnnotatedPojoMemberProvider detects potential regressions in the mapping logic\nplace using reflection. This implementation is due for removal in a future version of jOOQ.\n\nIf you wish to continue working with the Jakarta Persistence annotations, use the\njOOQ-jpa-extensions module and its DefaultAnnotatedPojoMemberProvider implementation\n".replace("{pojo}", type.getName()));
        }
        return false;
    }

    private static final ThrowingPredicate<? super AnnotatedElement, RuntimeException> hasPersistenceAnnotations() {
        return a -> Tools.anyMatch(a.getAnnotations(), LegacyAnnotatedPojoMemberProvider.isPersistenceAnnotation());
    }

    private static final ThrowingPredicate<? super Annotation, RuntimeException> isPersistenceAnnotation() {
        return a -> {
            String name = a.annotationType().getName();
            return name.startsWith("javax.persistence.") || name.startsWith("jakarta.persistence.");
        };
    }
}

