/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieveserver.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import org.apache.james.protocols.api.CommandDetectionSession;

public class ChannelManageSieveResponseWriter
implements CommandDetectionSession {
    private final Channel channel;
    private String cumulation = null;
    private boolean needsCommandInjectionDetection = true;

    public ChannelManageSieveResponseWriter(Channel channel) {
        this.channel = channel;
    }

    public void write(String response) {
        if (this.channel.isActive()) {
            this.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])response.getBytes(StandardCharsets.UTF_8)));
        }
    }

    public boolean needsCommandInjectionDetection() {
        return this.needsCommandInjectionDetection;
    }

    public void startDetectingCommandInjection() {
        this.needsCommandInjectionDetection = true;
    }

    public void stopDetectingCommandInjection() {
        this.needsCommandInjectionDetection = false;
    }

    public void resetCumulation() {
        this.cumulation = null;
    }

    public String cumulate(String s) {
        this.cumulation = this.cumulation == null || this.cumulation.equals("\r\n") ? s : this.cumulation + s;
        return this.cumulation;
    }
}

