/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetEffectiveRightsRequestControl
extends Control {
    @NotNull
    public static final String GET_EFFECTIVE_RIGHTS_REQUEST_OID = "1.3.6.1.4.1.42.2.27.9.5.2";
    @NotNull
    private static final String JSON_FIELD_ATTRIBUTES = "attributes";
    @NotNull
    private static final String JSON_FIELD_AUTHORIZATION_ID = "authorization-id";
    private static final long serialVersionUID = 354733122036206073L;
    @NotNull
    private final String authzID;
    @NotNull
    private final String[] attributes;

    public GetEffectiveRightsRequestControl(@NotNull String authzID, String ... attributes) {
        this(false, authzID, attributes);
    }

    public GetEffectiveRightsRequestControl(boolean isCritical, @NotNull String authzID, String ... attributes) {
        super(GET_EFFECTIVE_RIGHTS_REQUEST_OID, isCritical, GetEffectiveRightsRequestControl.encodeValue(authzID, attributes));
        this.authzID = authzID;
        this.attributes = attributes;
    }

    public GetEffectiveRightsRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1Element[] elements;
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GER_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GER_REQUEST_VALUE_NOT_SEQUENCE.get(e), e);
        }
        if (elements.length < 1 || elements.length > 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GER_REQUEST_INVALID_ELEMENT_COUNT.get(elements.length));
        }
        this.authzID = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
        if (elements.length == 2) {
            try {
                ASN1Element[] attrElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
                this.attributes = new String[attrElements.length];
                for (int i = 0; i < attrElements.length; ++i) {
                    this.attributes[i] = ASN1OctetString.decodeAsOctetString(attrElements[i]).stringValue();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GER_REQUEST_CANNOT_DECODE.get(e), e);
            }
        } else {
            this.attributes = StaticUtils.NO_STRINGS;
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String authzID, @Nullable String[] attributes) {
        ASN1Element[] elements;
        Validator.ensureNotNull(authzID);
        if (attributes == null || attributes.length == 0) {
            elements = new ASN1Element[]{new ASN1OctetString(authzID), new ASN1Sequence()};
        } else {
            ASN1Element[] attrElements = new ASN1Element[attributes.length];
            for (int i = 0; i < attributes.length; ++i) {
                attrElements[i] = new ASN1OctetString(attributes[i]);
            }
            elements = new ASN1Element[]{new ASN1OctetString(authzID), new ASN1Sequence(attrElements)};
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public String getAuthzID() {
        return this.authzID;
    }

    @NotNull
    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_EFFECTIVE_RIGHTS_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_AUTHORIZATION_ID, new JSONString(this.authzID));
        if (this.attributes.length > 0) {
            ArrayList<JSONString> attributeValues = new ArrayList<JSONString>();
            for (String attribute : this.attributes) {
                attributeValues.add(new JSONString(attribute));
            }
            valueFields.put(JSON_FIELD_ATTRIBUTES, new JSONArray(attributeValues));
        }
        return new JSONObject(new JSONField("oid", GET_EFFECTIVE_RIGHTS_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_GET_EFFECTIVE_RIGHTS_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static GetEffectiveRightsRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        String[] attributes;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new GetEffectiveRightsRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String authorizationID = valueObject.getFieldAsString(JSON_FIELD_AUTHORIZATION_ID);
        if (authorizationID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GER_REQUEST_JSON_MISSING_AUTHZ_ID.get(controlObject.toSingleLineString(), JSON_FIELD_AUTHORIZATION_ID));
        }
        List<JSONValue> attrValues = valueObject.getFieldAsArray(JSON_FIELD_ATTRIBUTES);
        if (attrValues == null) {
            attributes = StaticUtils.NO_STRINGS;
        } else {
            attributes = new String[attrValues.size()];
            for (int i = 0; i < attributes.length; ++i) {
                JSONValue v = attrValues.get(i);
                if (!(v instanceof JSONString)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GER_REQUEST_JSON_ATTR_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_ATTRIBUTES));
                }
                attributes[i] = ((JSONString)v).stringValue();
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_AUTHORIZATION_ID, JSON_FIELD_ATTRIBUTES)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GER_REQUEST_JSON_CONTROL_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new GetEffectiveRightsRequestControl(jsonControl.getCriticality(), authorizationID, attributes);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetEffectiveRightsRequestControl(authzId='");
        buffer.append(this.authzID);
        buffer.append('\'');
        if (this.attributes.length > 0) {
            buffer.append(", attributes={");
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.attributes[i]);
            }
            buffer.append('}');
        }
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

