/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.tasks.CollectSupportDataSecurityLevel;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class CollectSupportDataExtendedRequestProperties
implements Serializable {
    private static final long serialVersionUID = 5585016444537427389L;
    @Nullable
    private ASN1OctetString encryptionPassphrase;
    @Nullable
    private Boolean includeBinaryFiles;
    @Nullable
    private Boolean includeExpensiveData;
    @Nullable
    private Boolean includeExtensionSource;
    @Nullable
    private Boolean includeReplicationStateDump;
    @Nullable
    private Boolean useSequentialMode;
    @Nullable
    private CollectSupportDataLogCaptureWindow logCaptureWindow;
    @Nullable
    private CollectSupportDataSecurityLevel securityLevel;
    @Nullable
    private Integer jstackCount;
    @Nullable
    private Integer maximumFragmentSizeBytes;
    @Nullable
    private Integer proxyToServerPort;
    @Nullable
    private Integer reportCount;
    @Nullable
    private Integer reportIntervalSeconds;
    @Nullable
    private String archiveFileName;
    @Nullable
    private String comment;
    @Nullable
    private String proxyToServerAddress;

    public CollectSupportDataExtendedRequestProperties() {
        this.encryptionPassphrase = null;
        this.includeBinaryFiles = null;
        this.includeExpensiveData = null;
        this.includeExtensionSource = null;
        this.includeReplicationStateDump = null;
        this.useSequentialMode = null;
        this.logCaptureWindow = null;
        this.securityLevel = null;
        this.jstackCount = null;
        this.maximumFragmentSizeBytes = null;
        this.proxyToServerPort = null;
        this.reportCount = null;
        this.reportIntervalSeconds = null;
        this.archiveFileName = null;
        this.comment = null;
        this.proxyToServerAddress = null;
    }

    public CollectSupportDataExtendedRequestProperties(@NotNull CollectSupportDataExtendedRequestProperties properties) {
        this.encryptionPassphrase = properties.getEncryptionPassphrase();
        this.includeBinaryFiles = properties.getIncludeBinaryFiles();
        this.includeExpensiveData = properties.getIncludeExpensiveData();
        this.includeExtensionSource = properties.getIncludeExtensionSource();
        this.includeReplicationStateDump = properties.getIncludeReplicationStateDump();
        this.useSequentialMode = properties.getUseSequentialMode();
        this.logCaptureWindow = properties.getLogCaptureWindow();
        this.securityLevel = properties.getSecurityLevel();
        this.jstackCount = properties.getJStackCount();
        this.maximumFragmentSizeBytes = properties.getMaximumFragmentSizeBytes();
        this.proxyToServerPort = properties.getProxyToServerPort();
        this.reportCount = properties.getReportCount();
        this.reportIntervalSeconds = properties.getReportIntervalSeconds();
        this.archiveFileName = properties.getArchiveFileName();
        this.comment = properties.getComment();
        this.proxyToServerAddress = properties.getProxyToServerAddress();
    }

    public CollectSupportDataExtendedRequestProperties(@NotNull CollectSupportDataExtendedRequest request) {
        this.encryptionPassphrase = request.getEncryptionPassphrase();
        this.includeBinaryFiles = request.getIncludeBinaryFiles();
        this.includeExpensiveData = request.getIncludeExpensiveData();
        this.includeExtensionSource = request.getIncludeExtensionSource();
        this.includeReplicationStateDump = request.getIncludeReplicationStateDump();
        this.useSequentialMode = request.getUseSequentialMode();
        this.logCaptureWindow = request.getLogCaptureWindow();
        this.securityLevel = request.getSecurityLevel();
        this.jstackCount = request.getJStackCount();
        this.maximumFragmentSizeBytes = request.getMaximumFragmentSizeBytes();
        this.proxyToServerPort = request.getProxyToServerPort();
        this.reportCount = request.getReportCount();
        this.reportIntervalSeconds = request.getReportIntervalSeconds();
        this.archiveFileName = request.getArchiveFileName();
        this.comment = request.getComment();
        this.proxyToServerAddress = request.getProxyToServerAddress();
    }

    @Nullable
    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public void setArchiveFileName(@Nullable String archiveFileName) {
        this.archiveFileName = archiveFileName;
    }

    @Nullable
    public ASN1OctetString getEncryptionPassphrase() {
        return this.encryptionPassphrase;
    }

    public void setEncryptionPassphrase(@Nullable String encryptionPassphrase) {
        this.encryptionPassphrase = encryptionPassphrase == null ? null : new ASN1OctetString(-127, encryptionPassphrase);
    }

    public void setEncryptionPassphrase(@Nullable byte[] encryptionPassphrase) {
        this.encryptionPassphrase = encryptionPassphrase == null ? null : new ASN1OctetString(-127, encryptionPassphrase);
    }

    public void setEncryptionPassphrase(@Nullable ASN1OctetString encryptionPassphrase) {
        this.encryptionPassphrase = encryptionPassphrase == null ? null : new ASN1OctetString(-127, encryptionPassphrase.getValue());
    }

    @Nullable
    public Boolean getIncludeExpensiveData() {
        return this.includeExpensiveData;
    }

    public void setIncludeExpensiveData(@Nullable Boolean includeExpensiveData) {
        this.includeExpensiveData = includeExpensiveData;
    }

    @Nullable
    public Boolean getIncludeReplicationStateDump() {
        return this.includeReplicationStateDump;
    }

    public void setIncludeReplicationStateDump(@Nullable Boolean includeReplicationStateDump) {
        this.includeReplicationStateDump = includeReplicationStateDump;
    }

    @Nullable
    public Boolean getIncludeBinaryFiles() {
        return this.includeBinaryFiles;
    }

    public void setIncludeBinaryFiles(@Nullable Boolean includeBinaryFiles) {
        this.includeBinaryFiles = includeBinaryFiles;
    }

    @Nullable
    public Boolean getIncludeExtensionSource() {
        return this.includeExtensionSource;
    }

    public void setIncludeExtensionSource(@Nullable Boolean includeExtensionSource) {
        this.includeExtensionSource = includeExtensionSource;
    }

    @Nullable
    public Boolean getUseSequentialMode() {
        return this.useSequentialMode;
    }

    public void setUseSequentialMode(@Nullable Boolean useSequentialMode) {
        this.useSequentialMode = useSequentialMode;
    }

    @Nullable
    public CollectSupportDataSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(@Nullable CollectSupportDataSecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
    }

    @Nullable
    public Integer getJStackCount() {
        return this.jstackCount;
    }

    public void setJStackCount(@Nullable Integer jstackCount) {
        if (jstackCount != null) {
            Validator.ensureTrue(jstackCount >= 0, "If CollectSupportDataExtendedRequestProperties.jstackCount is non-null, then the value must be greater than or equal to zero.");
        }
        this.jstackCount = jstackCount;
    }

    @Nullable
    public Integer getReportCount() {
        return this.reportCount;
    }

    public void setReportCount(@Nullable Integer reportCount) {
        if (reportCount != null) {
            Validator.ensureTrue(reportCount >= 0, "If CollectSupportDataExtendedRequestProperties.reportCount is non-null, then the value must be greater than or equal to zero.");
        }
        this.reportCount = reportCount;
    }

    @Nullable
    public Integer getReportIntervalSeconds() {
        return this.reportIntervalSeconds;
    }

    public void setReportIntervalSeconds(@Nullable Integer reportIntervalSeconds) {
        if (reportIntervalSeconds != null) {
            Validator.ensureTrue(reportIntervalSeconds > 0, "If CollectSupportDataExtendedRequestProperties.reportIntervalSeconds is non-null, then the value must be greater than zero.");
        }
        this.reportIntervalSeconds = reportIntervalSeconds;
    }

    @Nullable
    public CollectSupportDataLogCaptureWindow getLogCaptureWindow() {
        return this.logCaptureWindow;
    }

    public void setLogCaptureWindow(@Nullable CollectSupportDataLogCaptureWindow logCaptureWindow) {
        this.logCaptureWindow = logCaptureWindow;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public void setComment(@Nullable String comment) {
        this.comment = comment;
    }

    @Nullable
    public String getProxyToServerAddress() {
        return this.proxyToServerAddress;
    }

    @Nullable
    public Integer getProxyToServerPort() {
        return this.proxyToServerPort;
    }

    public void setProxyToServer(@Nullable String address, @Nullable Integer port) {
        if (address == null) {
            Validator.ensureTrue(port == null, "If CollectSupportDataExtendedRequestProperties.proxyToServer.address is null, then CollectSupportDataExtendedRequestProperties.proxyToServer.port must also be null.");
        } else {
            Validator.ensureFalse(address.isEmpty(), "If CollectSupportDataExtendedRequestProperties.proxyToServer.address is non-null, then it must also be non-empty.");
            Validator.ensureNotNullWithMessage(port, "If CollectSupportDataExtendedRequestProperties.proxyToServer.address is non-null, then CollectSupportDataExtendedRequestProperties.proxyToServer.port must also be non-null.");
            Validator.ensureTrue(port >= 1 && port <= 65535, "If CollectSupportDataExtendedRequestProperties.proxyToServer.port is non-null, then its value must be between 1 and 65535, inclusive.");
        }
        this.proxyToServerAddress = address;
        this.proxyToServerPort = port;
    }

    @Nullable
    public Integer getMaximumFragmentSizeBytes() {
        return this.maximumFragmentSizeBytes;
    }

    public void setMaximumFragmentSizeBytes(@Nullable Integer maximumFragmentSizeBytes) {
        if (maximumFragmentSizeBytes != null) {
            Validator.ensureTrue(maximumFragmentSizeBytes > 0, "If CollectSupportDataExtendedRequestProperties.maximumFragmentSizeBytes is non-null, then its value must be greater than zero.");
        }
        this.maximumFragmentSizeBytes = maximumFragmentSizeBytes;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("CollectSupportDataArchiveProperties(");
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "archiveFileName", this.archiveFileName);
        if (this.encryptionPassphrase != null) {
            CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "encryptionPassphrase", "*****REDACTED*****");
        }
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "includeExpensiveData", this.includeExpensiveData);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "includeReplicationStateDump", this.includeReplicationStateDump);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "includeBinaryFiles", this.includeBinaryFiles);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "includeExtensionSource", this.includeExtensionSource);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "securityLevel", (Object)this.securityLevel);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "useSequentialMode", this.useSequentialMode);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "jstackCount", this.jstackCount);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "reportCount", this.reportCount);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "reportIntervalSeconds", this.reportIntervalSeconds);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "logCaptureWindow", this.logCaptureWindow);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "comment", this.comment);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "proxyToServerAddress", this.proxyToServerAddress);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "proxyToServerPort", this.proxyToServerPort);
        CollectSupportDataExtendedRequestProperties.appendNameValuePair(buffer, "maximumFragmentSizeBytes", this.maximumFragmentSizeBytes);
        buffer.append(')');
    }

    private static void appendNameValuePair(@NotNull StringBuilder buffer, @NotNull String name, @Nullable Object value) {
        if (value == null) {
            return;
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '(') {
            buffer.append(", ");
        }
        buffer.append(name);
        buffer.append('=');
        if (value instanceof Boolean || value instanceof Integer || value instanceof CollectSupportDataLogCaptureWindow) {
            buffer.append(value);
        } else {
            buffer.append('\'');
            buffer.append(value);
            buffer.append('\'');
        }
    }
}

