/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ActiveOperationsMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String ACTIVE_OPERATIONS_MONITOR_OC = "ds-active-operations-monitor-entry";
    @NotNull
    private static final String ATTR_NUM_OPS_IN_PROGRESS = "num-operations-in-progress";
    @NotNull
    private static final String ATTR_NUM_PSEARCHES_IN_PROGRESS = "num-persistent-searches-in-progress";
    @NotNull
    private static final String ATTR_OP_IN_PROGRESS = "operation-in-progress";
    @NotNull
    private static final String ATTR_PSEARCH_IN_PROGRESS = "persistent-search-in-progress";
    private static final long serialVersionUID = -6583987693176406802L;
    @NotNull
    private final List<String> activeOperations = this.getStrings("operation-in-progress");
    @NotNull
    private final List<String> activePersistentSearches = this.getStrings("persistent-search-in-progress");
    @Nullable
    private final Long numOpsInProgress = this.getLong("num-operations-in-progress");
    @Nullable
    private final Long numPsearchesInProgress = this.getLong("num-persistent-searches-in-progress");

    public ActiveOperationsMonitorEntry(@NotNull Entry entry) {
        super(entry);
    }

    @Nullable
    public Long getNumOperationsInProgress() {
        return this.numOpsInProgress;
    }

    @NotNull
    public List<String> getActiveOperations() {
        return this.activeOperations;
    }

    @Nullable
    public Long getNumPersistentSearchesInProgress() {
        return this.numPsearchesInProgress;
    }

    @NotNull
    public List<String> getActivePersistentSearches() {
        return this.activePersistentSearches;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_ACTIVE_OPERATIONS_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_ACTIVE_OPERATIONS_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(4));
        if (this.numOpsInProgress != null) {
            ActiveOperationsMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_OPS_IN_PROGRESS, MonitorMessages.INFO_ACTIVE_OPERATIONS_DISPNAME_NUM_OPS_IN_PROGRESS.get(), MonitorMessages.INFO_ACTIVE_OPERATIONS_DESC_NUM_OPS_IN_PROGRESS.get(), this.numOpsInProgress);
        }
        if (!this.activeOperations.isEmpty()) {
            ActiveOperationsMonitorEntry.addMonitorAttribute(attrs, ATTR_OP_IN_PROGRESS, MonitorMessages.INFO_ACTIVE_OPERATIONS_DISPNAME_OPS_IN_PROGRESS.get(), MonitorMessages.INFO_ACTIVE_OPERATIONS_DESC_OPS_IN_PROGRESS.get(), this.activeOperations);
        }
        if (this.numPsearchesInProgress != null) {
            ActiveOperationsMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_PSEARCHES_IN_PROGRESS, MonitorMessages.INFO_ACTIVE_OPERATIONS_DISPNAME_NUM_PSEARCHES_IN_PROGRESS.get(), MonitorMessages.INFO_ACTIVE_OPERATIONS_DESC_NUM_PSEARCHES_IN_PROGRESS.get(), this.numPsearchesInProgress);
        }
        if (!this.activePersistentSearches.isEmpty()) {
            ActiveOperationsMonitorEntry.addMonitorAttribute(attrs, ATTR_PSEARCH_IN_PROGRESS, MonitorMessages.INFO_ACTIVE_OPERATIONS_DISPNAME_PSEARCHES_IN_PROGRESS.get(), MonitorMessages.INFO_ACTIVE_OPERATIONS_DESC_PSEARCHES_IN_PROGRESS.get(), this.activePersistentSearches);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

