/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class DissectProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String appendSeparator;
    private final String field;
    private final boolean ignoreMissing;
    private final String pattern;
    public static final JsonpDeserializer<DissectProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DissectProcessor::setupDissectProcessorDeserializer);

    private DissectProcessor(Builder builder) {
        super(builder);
        this.appendSeparator = ApiTypeHelper.requireNonNull(builder.appendSeparator, this, "appendSeparator");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = ApiTypeHelper.requireNonNull(builder.ignoreMissing, this, "ignoreMissing");
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
    }

    public static DissectProcessor of(Function<Builder, ObjectBuilder<DissectProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Dissect;
    }

    public final String appendSeparator() {
        return this.appendSeparator;
    }

    public final String field() {
        return this.field;
    }

    public final boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("append_separator");
        generator.write(this.appendSeparator);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("ignore_missing");
        generator.write(this.ignoreMissing);
        generator.writeKey("pattern");
        generator.write(this.pattern);
    }

    protected static void setupDissectProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::appendSeparator, JsonpDeserializer.stringDeserializer(), "append_separator");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DissectProcessor> {
        private String appendSeparator;
        private String field;
        private Boolean ignoreMissing;
        private String pattern;

        public final Builder appendSeparator(String value) {
            this.appendSeparator = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DissectProcessor build() {
            this._checkSingleUse();
            return new DissectProcessor(this);
        }
    }
}

