/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.authentication;

import io.r2dbc.postgresql.authentication.AuthenticationHandler;
import io.r2dbc.postgresql.authentication.FluentMessageDigest;
import io.r2dbc.postgresql.message.backend.AuthenticationCleartextPassword;
import io.r2dbc.postgresql.message.backend.AuthenticationMD5Password;
import io.r2dbc.postgresql.message.backend.AuthenticationMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.PasswordMessage;
import io.r2dbc.postgresql.util.Assert;

public final class PasswordAuthenticationHandler
implements AuthenticationHandler {
    private final CharSequence password;
    private final String username;

    public PasswordAuthenticationHandler(CharSequence password, String username) {
        this.password = Assert.requireNonNull(password, "password must not be null");
        this.username = Assert.requireNonNull(username, "username must not be null");
    }

    public static boolean supports(AuthenticationMessage message) {
        Assert.requireNonNull(message, "message must not be null");
        return message instanceof AuthenticationCleartextPassword || message instanceof AuthenticationMD5Password;
    }

    @Override
    public FrontendMessage handle(AuthenticationMessage message) {
        Assert.requireNonNull(message, "message must not be null");
        if (message instanceof AuthenticationCleartextPassword) {
            return this.handleAuthenticationClearTextPassword();
        }
        if (message instanceof AuthenticationMD5Password) {
            return this.handleAuthenticationMD5Password((AuthenticationMD5Password)message);
        }
        throw new IllegalArgumentException(String.format("Cannot handle %s message", message.getClass().getSimpleName()));
    }

    private PasswordMessage handleAuthenticationClearTextPassword() {
        return new PasswordMessage(this.password);
    }

    private FrontendMessage handleAuthenticationMD5Password(AuthenticationMD5Password message) {
        String shadow = new FluentMessageDigest("md5").update("%s%s", this.password, this.username).digest();
        String transfer = new FluentMessageDigest("md5").update(shadow).update(message.getSalt()).digest();
        return new PasswordMessage(String.format("md5%s", transfer));
    }
}

