/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlDateTimeFormatter;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

final class LocalDateTimeCodec
extends AbstractTemporalCodec<LocalDateTime> {
    private final Supplier<ZoneId> zoneIdSupplier;

    LocalDateTimeCodec(ByteBufAllocator byteBufAllocator, Supplier<ZoneId> zoneIdSupplier) {
        super(LocalDateTime.class, byteBufAllocator, PostgresqlObjectId.TIMESTAMP, PostgresqlObjectId.TIMESTAMP_ARRAY, PostgresqlDateTimeFormatter::toString);
        this.zoneIdSupplier = Assert.requireNonNull(zoneIdSupplier, "zoneIdSupplier must not be null");
    }

    @Override
    LocalDateTime doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends LocalDateTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, LocalDateTime.class, temporal -> {
            ZoneId zone = this.zoneIdSupplier.get();
            if (temporal instanceof LocalDate) {
                return ((LocalDate)temporal).atStartOfDay(zone).toLocalDateTime();
            }
            Instant instant = Instant.from(temporal);
            ZoneOffset offset = zone.getRules().getOffset(instant);
            return instant.atOffset(offset).toLocalDateTime();
        });
    }
}

