/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.postgres;

import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.postgres.PostgresMailRepositoryContentDAO;
import org.apache.mailet.Mail;
import reactor.core.publisher.Mono;

public class PostgresMailRepository
implements MailRepository {
    private final MailRepositoryUrl url;
    private final PostgresMailRepositoryContentDAO postgresMailRepositoryContentDAO;

    @Inject
    public PostgresMailRepository(MailRepositoryUrl url, PostgresMailRepositoryContentDAO postgresMailRepositoryContentDAO) {
        this.url = url;
        this.postgresMailRepositoryContentDAO = postgresMailRepositoryContentDAO;
    }

    public long size() throws MessagingException {
        return this.postgresMailRepositoryContentDAO.size(this.url);
    }

    public Mono<Long> sizeReactive() {
        return this.postgresMailRepositoryContentDAO.sizeReactive(this.url);
    }

    public MailKey store(Mail mail) throws MessagingException {
        return this.postgresMailRepositoryContentDAO.store(mail, this.url);
    }

    public Iterator<MailKey> list() throws MessagingException {
        return this.postgresMailRepositoryContentDAO.list(this.url);
    }

    public Mail retrieve(MailKey key) {
        return this.postgresMailRepositoryContentDAO.retrieve(key, this.url);
    }

    public void remove(MailKey key) {
        this.postgresMailRepositoryContentDAO.remove(key, this.url);
    }

    public void remove(Collection<MailKey> keys) {
        this.postgresMailRepositoryContentDAO.remove(keys, this.url);
    }

    public void removeAll() {
        this.postgresMailRepositoryContentDAO.removeAll(this.url);
    }
}

