/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.postgres;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.RecipientId;
import org.apache.james.vacation.postgres.PostgresVacationDataDefinition;
import org.jooq.Condition;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PostgresNotificationRegistryDAO {
    private final PostgresExecutor postgresExecutor;
    private final ZonedDateTimeProvider zonedDateTimeProvider;

    public PostgresNotificationRegistryDAO(PostgresExecutor postgresExecutor, ZonedDateTimeProvider zonedDateTimeProvider) {
        this.postgresExecutor = postgresExecutor;
        this.zonedDateTimeProvider = zonedDateTimeProvider;
    }

    public Mono<Void> register(AccountId accountId, RecipientId recipientId, Optional<ZonedDateTime> expiryDate) {
        return this.postgresExecutor.executeVoid(dsl -> Mono.from((Publisher)dsl.insertInto(PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.TABLE_NAME).set(PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.ACCOUNT_ID, (Object)accountId.getIdentifier()).set(PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.RECIPIENT_ID, (Object)recipientId.getAsString()).set(PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.EXPIRY_DATE, (Object)expiryDate.map(zonedDateTime -> zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime()).orElse(null))));
    }

    public Mono<Boolean> isRegistered(AccountId accountId, RecipientId recipientId) {
        LocalDateTime currentUTCTime = ((ZonedDateTime)this.zonedDateTimeProvider.get()).withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime();
        return this.postgresExecutor.executeExists(dsl -> dsl.selectOne().from(PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.TABLE_NAME).where(new Condition[]{PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier()), PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.RECIPIENT_ID.eq((Object)recipientId.getAsString()), PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.EXPIRY_DATE.ge((Object)currentUTCTime).or(PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.EXPIRY_DATE.isNull())}));
    }

    public Mono<Void> flush(AccountId accountId) {
        return this.postgresExecutor.executeVoid(dsl -> Mono.from((Publisher)dsl.deleteFrom(PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.TABLE_NAME).where(PostgresVacationDataDefinition.PostgresVacationNotificationRegistryTable.ACCOUNT_ID.eq((Object)accountId.getIdentifier()))));
    }
}

