/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.smtpserver.jmx.HookStats;

public class HookResultJMXMonitor
implements HookResultHook,
ExtensibleHandler,
ProtocolHandler {
    private final Map<String, HookStats> hookStats = new HashMap<String, HookStats>();
    private String jmxPath;

    public HookResult onHookResult(SMTPSession session, HookResult result, long executionTime, Hook hook) {
        String hookName = hook.getClass().getName();
        HookStats stats = this.hookStats.get(hookName);
        if (stats != null) {
            stats.increment(result.getResult());
        }
        return result;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList marker = new ArrayList();
        marker.add(Hook.class);
        return marker;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(Hook.class)) {
            for (Object hook : extension) {
                if (this.equals(hook)) continue;
                String hookName = hook.getClass().getName();
                try {
                    this.hookStats.put(hookName, new HookStats(this.jmxPath, hookName));
                }
                catch (Exception e) {
                    throw new WiringException("Unable to wire Hooks", (Throwable)e);
                }
            }
        }
    }

    protected String getDefaultJMXName() {
        return "smtpserver";
    }

    public void init(Configuration config) throws ConfigurationException {
        this.jmxPath = config.getString("jmxName", this.getDefaultJMXName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<String, HookStats> map = this.hookStats;
        synchronized (map) {
            for (HookStats hookStats1 : this.hookStats.values()) {
                hookStats1.dispose();
            }
            this.hookStats.clear();
        }
    }
}

