/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.components;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.components.CassandraQuotaCurrentValueTable;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaCurrentValue;
import org.apache.james.core.quota.QuotaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraQuotaCurrentValueDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraQuotaCurrentValueDao.class);
    private final CassandraAsyncExecutor queryExecutor;
    private final PreparedStatement increaseStatement;
    private final PreparedStatement decreaseStatement;
    private final PreparedStatement getQuotaCurrentValueStatement;
    private final PreparedStatement getQuotasByComponentStatement;
    private final PreparedStatement deleteQuotaCurrentValueStatement;

    @Inject
    public CassandraQuotaCurrentValueDao(CqlSession session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
        this.increaseStatement = session.prepare(this.increaseStatement().build());
        this.decreaseStatement = session.prepare(this.decreaseStatement().build());
        this.getQuotaCurrentValueStatement = session.prepare(this.getQuotaCurrentValueStatement().build());
        this.getQuotasByComponentStatement = session.prepare(this.getQuotasByComponentStatement().build());
        this.deleteQuotaCurrentValueStatement = session.prepare(this.deleteQuotaCurrentValueStatement().build());
    }

    public Mono<Void> increase(QuotaCurrentValue.Key quotaKey, long amount) {
        return this.queryExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.increaseStatement.bind(new Object[0]).setString(CassandraQuotaCurrentValueTable.QUOTA_COMPONENT, quotaKey.getQuotaComponent().getValue())).setString(CassandraQuotaCurrentValueTable.IDENTIFIER, quotaKey.getIdentifier())).setString(CassandraQuotaCurrentValueTable.QUOTA_TYPE, quotaKey.getQuotaType().getValue())).setLong(CassandraQuotaCurrentValueTable.CURRENT_VALUE, amount)).onErrorResume(ex -> {
            LOGGER.warn("Failure when increasing {} {} quota for {}. Quota current value is thus not updated and needs recomputation", new Object[]{quotaKey.getQuotaComponent().getValue(), quotaKey.getQuotaType().getValue(), quotaKey.getIdentifier(), ex});
            return Mono.empty();
        });
    }

    public Mono<Void> decrease(QuotaCurrentValue.Key quotaKey, long amount) {
        return this.queryExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.decreaseStatement.bind(new Object[0]).setString(CassandraQuotaCurrentValueTable.QUOTA_COMPONENT, quotaKey.getQuotaComponent().getValue())).setString(CassandraQuotaCurrentValueTable.IDENTIFIER, quotaKey.getIdentifier())).setString(CassandraQuotaCurrentValueTable.QUOTA_TYPE, quotaKey.getQuotaType().getValue())).setLong(CassandraQuotaCurrentValueTable.CURRENT_VALUE, amount)).onErrorResume(ex -> {
            LOGGER.warn("Failure when decreasing {} {} quota for {}. Quota current value is thus not updated and needs recomputation", new Object[]{quotaKey.getQuotaComponent().getValue(), quotaKey.getQuotaType().getValue(), quotaKey.getIdentifier(), ex});
            return Mono.empty();
        });
    }

    public Mono<QuotaCurrentValue> getQuotaCurrentValue(QuotaCurrentValue.Key quotaKey) {
        return this.queryExecutor.executeSingleRow((Statement)((BoundStatement)((BoundStatement)this.getQuotaCurrentValueStatement.bind(new Object[0]).setString(CassandraQuotaCurrentValueTable.QUOTA_COMPONENT, quotaKey.getQuotaComponent().getValue())).setString(CassandraQuotaCurrentValueTable.IDENTIFIER, quotaKey.getIdentifier())).setString(CassandraQuotaCurrentValueTable.QUOTA_TYPE, quotaKey.getQuotaType().getValue())).map(row -> this.convertRowToModel((Row)row));
    }

    public Mono<Void> deleteQuotaCurrentValue(QuotaCurrentValue.Key quotaKey) {
        return this.queryExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.deleteQuotaCurrentValueStatement.bind(new Object[0]).setString(CassandraQuotaCurrentValueTable.QUOTA_COMPONENT, quotaKey.getQuotaComponent().getValue())).setString(CassandraQuotaCurrentValueTable.IDENTIFIER, quotaKey.getIdentifier())).setString(CassandraQuotaCurrentValueTable.QUOTA_TYPE, quotaKey.getQuotaType().getValue()));
    }

    public Flux<QuotaCurrentValue> getQuotasByComponent(QuotaComponent quotaComponent, String identifier) {
        return this.queryExecutor.executeRows((Statement)((BoundStatement)this.getQuotasByComponentStatement.bind(new Object[0]).setString(CassandraQuotaCurrentValueTable.QUOTA_COMPONENT, quotaComponent.getValue())).setString(CassandraQuotaCurrentValueTable.IDENTIFIER, identifier)).map(row -> this.convertRowToModel((Row)row));
    }

    private Update increaseStatement() {
        return (Update)QueryBuilder.update((String)"quotaCurrentValue").increment(CassandraQuotaCurrentValueTable.CURRENT_VALUE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.CURRENT_VALUE)).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_TYPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_TYPE))});
    }

    private Update decreaseStatement() {
        return (Update)QueryBuilder.update((String)"quotaCurrentValue").decrement(CassandraQuotaCurrentValueTable.CURRENT_VALUE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.CURRENT_VALUE)).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_TYPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_TYPE))});
    }

    private Select getQuotaCurrentValueStatement() {
        return (Select)QueryBuilder.selectFrom((String)"quotaCurrentValue").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_TYPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_TYPE))});
    }

    private Select getQuotasByComponentStatement() {
        return (Select)QueryBuilder.selectFrom((String)"quotaCurrentValue").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT))});
    }

    private Delete deleteQuotaCurrentValueStatement() {
        return (Delete)QueryBuilder.deleteFrom((String)"quotaCurrentValue").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.IDENTIFIER)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_COMPONENT)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_TYPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaCurrentValueTable.QUOTA_TYPE))});
    }

    private QuotaCurrentValue convertRowToModel(Row row) {
        return QuotaCurrentValue.builder().quotaComponent(QuotaComponent.of((String)((String)row.get(CassandraQuotaCurrentValueTable.QUOTA_COMPONENT, String.class)))).identifier((String)row.get(CassandraQuotaCurrentValueTable.IDENTIFIER, String.class)).quotaType(QuotaType.of((String)((String)row.get(CassandraQuotaCurrentValueTable.QUOTA_TYPE, String.class)))).currentValue(((Long)row.get(CassandraQuotaCurrentValueTable.CURRENT_VALUE, Long.class)).longValue()).build();
    }
}

