/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UTCDate$;
import org.apache.james.jmap.mail.AttachmentsMetadata;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailBodyMetadata;
import org.apache.james.jmap.mail.EmailBodyPart;
import org.apache.james.jmap.mail.EmailBodyPart$;
import org.apache.james.jmap.mail.EmailFastViewReader$;
import org.apache.james.jmap.mail.EmailFastViewWithAttachments;
import org.apache.james.jmap.mail.EmailFullView;
import org.apache.james.jmap.mail.EmailFullViewFactory;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailHeaderValue;
import org.apache.james.jmap.mail.EmailHeaders;
import org.apache.james.jmap.mail.EmailHeaders$;
import org.apache.james.jmap.mail.EmailMetadata;
import org.apache.james.jmap.mail.EmailView;
import org.apache.james.jmap.mail.EmailViewReader;
import org.apache.james.jmap.mail.FastViewAvailable;
import org.apache.james.jmap.mail.FastViewResult;
import org.apache.james.jmap.mail.FastViewUnavailable;
import org.apache.james.jmap.mail.GenericEmailViewReader;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.method.ZoneIdProvider;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.html.HtmlTextExtractor;
import reactor.core.Disposable;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\b\u0010\tiA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!A\u0005A!A!\u0002\u0013I\u0005\"\u0002'\u0001\t\u0003i\u0005bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B0\t\u000b\u0019\u0004A\u0011I4\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA1\u0001\u0011%\u00111\r\u0005\b\u0003o\u0002A\u0011BA=\u0005)*U.Y5m\r\u0006\u001cHOV5fo^KG\u000f[!ui\u0006\u001c\u0007.\\3oiNlU\r^1eCR\f'+Z1eKJT!\u0001E\t\u0002\t5\f\u0017\u000e\u001c\u0006\u0003%M\tAA[7ba*\u0011A#F\u0001\u0006U\u0006lWm\u001d\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0004E\r*S\"A\b\n\u0005\u0011z!aD#nC&dg+[3x%\u0016\fG-\u001a:\u0011\u0005\t2\u0013BA\u0014\u0010\u0005%)U.Y5m-&,w/\u0001\tnKN\u001c\u0018mZ3JI6\u000bg.Y4feB\u0011!&L\u0007\u0002W)\u0011AfE\u0001\b[\u0006LGNY8y\u0013\tq3F\u0001\tNKN\u001c\u0018mZ3JI6\u000bg.Y4fe\u0006IR.Z:tC\u001e,g)Y:u-&,w\u000f\u0015:pU\u0016\u001cG/[8o!\t\td'D\u00013\u0015\t\u0019D'A\u0006qe>TWm\u0019;j_:\u001c(BA\u001b\u0012\u0003\r\t\u0007/[\u0005\u0003oI\u0012\u0011$T3tg\u0006<WMR1tiZKWm\u001e)s_*,7\r^5p]\u0006\t\u0002\u000e^7m)\u0016DH/\u0012=ue\u0006\u001cGo\u001c:\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u00025u[2T!AP\n\u0002\tU$\u0018\u000e\\\u0005\u0003\u0001n\u0012\u0011\u0003\u0013;nYR+\u0007\u0010^#yiJ\f7\r^8s\u00039QxN\\3JIB\u0013xN^5eKJ\u0004\"a\u0011$\u000e\u0003\u0011S!!R\t\u0002\r5,G\u000f[8e\u0013\t9EI\u0001\b[_:,\u0017\n\u001a)s_ZLG-\u001a:\u0002\u001f\u0019,H\u000e\u001c,jK^4\u0015m\u0019;pef\u0004\"A\t&\n\u0005-{!\u0001F#nC&dg)\u001e7m-&,wOR1di>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0007\u001d>\u0003\u0016KU*\u0011\u0005\t\u0002\u0001\"\u0002\u0015\u0007\u0001\u0004I\u0003\"B\u0018\u0007\u0001\u0004\u0001\u0004\"\u0002\u001d\u0007\u0001\u0004I\u0004\"B!\u0007\u0001\u0004\u0011\u0005\"\u0002%\u0007\u0001\u0004I\u0005F\u0001\u0004V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0004j]*,7\r\u001e\u0006\u00025\u00069!.Y6beR\f\u0017B\u0001/X\u0005\u0019IeN[3di\u0006Qa-\u001e7m%\u0016\fG-\u001a:\u0016\u0003}\u00032A\t1c\u0013\t\twB\u0001\fHK:,'/[2F[\u0006LGNV5foJ+\u0017\rZ3s!\t\u00113-\u0003\u0002e\u001f\tiQ)\\1jY\u001a+H\u000e\u001c,jK^\f1BZ;mYJ+\u0017\rZ3sA\u0005!!/Z1e+\tAg\u000f\u0006\u0004jy\u0006\u0005\u00121\u0006\t\u0004UJ$X\"A6\u000b\u00051l\u0017!\u00039vE2L7\u000f[3s\u0015\tqbN\u0003\u0002pa\u0006!1m\u001c:f\u0015\u0005\t\u0018a\u0002:fC\u000e$xN]\u0005\u0003g.\u0014Qa\u0015$mkb\u0004\"!\u001e<\r\u0001\u0011)q/\u0003b\u0001q\n\tA+\u0005\u0002&sB\u0011AD_\u0005\u0003wv\u00111!\u00118z\u0011\u0015i\u0018\u00021\u0001\u007f\u0003\rIGm\u001d\t\u0006\u007f\u0006=\u0011Q\u0003\b\u0005\u0003\u0003\tYA\u0004\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9!G\u0001\u0007yI|w\u000e\u001e \n\u0003yI1!!\u0004\u001e\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0005\u0002\u0014\t\u00191+Z9\u000b\u0007\u00055Q\u0004\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYbK\u0001\u0006[>$W\r\\\u0005\u0005\u0003?\tIBA\u0005NKN\u001c\u0018mZ3JI\"9\u00111E\u0005A\u0002\u0005\u0015\u0012a\u0002:fcV,7\u000f\u001e\t\u0004E\u0005\u001d\u0012bAA\u0015\u001f\tyQ)\\1jY\u001e+GOU3rk\u0016\u001cH\u000fC\u0004\u0002.%\u0001\r!a\f\u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B\u0019!&!\r\n\u0007\u0005M2F\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0002\u0019Q|W)\\1jYZKWm^:\u0016\t\u0005e\u0012q\b\u000b\t\u0003w\t\t%!\u0014\u0002PA!!N]A\u001f!\r)\u0018q\b\u0003\u0006o*\u0011\r\u0001\u001f\u0005\b\u0003\u0007R\u0001\u0019AA#\u0003\u001d\u0011Xm];miN\u0004Ra`A\b\u0003\u000f\u00022AIA%\u0013\r\tYe\u0004\u0002\u000f\r\u0006\u001cHOV5foJ+7/\u001e7u\u0011\u001d\t\u0019C\u0003a\u0001\u0003KAq!!\f\u000b\u0001\u0004\ty#\u0001\nti>\u0014Xm\u00148DC\u000eDW-T5tg\u0016\u001cH\u0003BA+\u0003;\u0002B!a\u0016\u0002Z5\ta.C\u0002\u0002\\9\u0014!\u0002R5ta>\u001c\u0018M\u00197f\u0011\u0019\tyf\u0003a\u0001E\u0006Aa-\u001e7m-&,w/A\u0006u_\u001a\u000b7\u000f\u001e,jK^\u001cH\u0003CA3\u0003O\n\u0019(!\u001e\u0011\u0007)\u0014X\u0005C\u0004\u0002j1\u0001\r!a\u001b\u0002\u0013\u0019\f7\u000f\u001e,jK^\u001c\b#B@\u0002\u0010\u00055\u0004c\u0001\u0012\u0002p%\u0019\u0011\u0011O\b\u0003#\u0019\u000b7\u000f\u001e,jK^\fe/Y5mC\ndW\rC\u0004\u0002$1\u0001\r!!\n\t\u000f\u00055B\u00021\u0001\u00020\u00059Ao\\#nC&dG\u0003BA>\u0003G#b!! \u0002\b\u0006e\u0005#BA@\u0003\u0007+SBAAA\u0015\tqT$\u0003\u0003\u0002\u0006\u0006\u0005%a\u0001+ss\"9\u0011\u0011R\u0007A\u0002\u0005-\u0015aB7fgN\fw-\u001a\t\b9\u00055\u0015QCAI\u0013\r\ty)\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b}\fy!a%\u0011\t\u0005]\u0011QS\u0005\u0005\u0003/\u000bIBA\u0007NKN\u001c\u0018mZ3SKN,H\u000e\u001e\u0005\b\u00037k\u0001\u0019AAO\u0003!1\u0017m\u001d;WS\u0016<\bcA\u0019\u0002 &\u0019\u0011\u0011\u0015\u001a\u0003I5+7o]1hK\u001a\u000b7\u000f\u001e,jK^\u0004&/Z2p[B,H/\u001a3Qe>\u0004XM\u001d;jKNDq!a\t\u000e\u0001\u0004\t)\u0003")
public class EmailFastViewWithAttachmentsMetadataReader
implements EmailViewReader<EmailView> {
    private final MessageIdManager messageIdManager;
    private final MessageFastViewProjection messageFastViewProjection;
    private final ZoneIdProvider zoneIdProvider;
    private final GenericEmailViewReader<EmailFullView> fullReader;

    private GenericEmailViewReader<EmailFullView> fullReader() {
        return this.fullReader;
    }

    @Override
    public <T> SFlux<T> read(scala.collection.immutable.Seq<MessageId> ids, EmailGetRequest request, MailboxSession mailboxSession) {
        return SMono$.MODULE$.fromPublisher(this.messageFastViewProjection.retrieve((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(ids).asJava())).map((Function1 & Serializable)x$39 -> CollectionConverters$.MODULE$.MapHasAsScala(x$39).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)fastViews -> (scala.collection.immutable.Seq)ids.map((Function1 & Serializable)id -> (Product)fastViews.get(id).map((Function1 & Serializable)x$40 -> new FastViewAvailable((MessageId)id, (MessageFastViewPrecomputedProperties)x$40)).getOrElse((Function0 & Serializable)() -> new FastViewUnavailable((MessageId)id)))).flatMapMany((Function1 & Serializable)results -> this.toEmailViews((scala.collection.immutable.Seq<FastViewResult>)results, request, mailboxSession));
    }

    private <T> SFlux<T> toEmailViews(scala.collection.immutable.Seq<FastViewResult> results, EmailGetRequest request, MailboxSession mailboxSession) {
        scala.collection.immutable.Seq availables = (scala.collection.immutable.Seq)results.flatMap((Function1 & Serializable)x0$1 -> {
            FastViewResult fastViewResult = x0$1;
            if (fastViewResult instanceof FastViewAvailable) {
                FastViewAvailable fastViewAvailable = (FastViewAvailable)fastViewResult;
                return new Some((Object)fastViewAvailable);
            }
            return None$.MODULE$;
        });
        scala.collection.immutable.Seq unavailables = (scala.collection.immutable.Seq)results.flatMap((Function1 & Serializable)x0$2 -> {
            FastViewResult fastViewResult = x0$2;
            if (fastViewResult instanceof FastViewUnavailable) {
                FastViewUnavailable fastViewUnavailable = (FastViewUnavailable)fastViewResult;
                return new Some((Object)fastViewUnavailable);
            }
            return None$.MODULE$;
        });
        return SFlux$.MODULE$.merge((scala.collection.immutable.Seq)new .colon.colon(this.toFastViews((scala.collection.immutable.Seq<FastViewAvailable>)availables, request, mailboxSession), (List)new .colon.colon((Object)this.fullReader().read((scala.collection.immutable.Seq<MessageId>)((scala.collection.immutable.Seq)unavailables.map((Function1 & Serializable)x$41 -> x$41.id())), request, mailboxSession).doOnNext((Function1 & Serializable)fullView -> {
            this.storeOnCacheMisses(fullView);
            return BoxedUnit.UNIT;
        }), (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3());
    }

    private Disposable storeOnCacheMisses(EmailFullView fullView) {
        return SMono$.MODULE$.fromPublisher(this.messageFastViewProjection.store(fullView.metadata().id(), MessageFastViewPrecomputedProperties.builder().preview(fullView.bodyMetadata().preview()).hasAttachment(fullView.bodyMetadata().hasAttachment()).build())).doOnError((Function1 & Serializable)e -> {
            EmailFastViewWithAttachmentsMetadataReader.$anonfun$storeOnCacheMisses$2(fullView, e);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.parallel()).subscribe();
    }

    private SFlux<EmailView> toFastViews(scala.collection.immutable.Seq<FastViewAvailable> fastViews, EmailGetRequest request, MailboxSession mailboxSession) {
        Map fastViewsAsMap = ((IterableOnceOps)fastViews.map((Function1 & Serializable)e -> new Tuple2((Object)e.id(), (Object)e.fastView()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Seq ids = (scala.collection.immutable.Seq)fastViews.map((Function1 & Serializable)x$42 -> x$42.id());
        return SFlux$.MODULE$.fromPublisher(this.messageIdManager.getMessagesReactive((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ids).asJava(), FetchGroup.HEADERS_WITH_ATTACHMENTS_METADATA, mailboxSession)).collectSeq().flatMapIterable((Function1 & Serializable)messages -> messages.groupBy((Function1 & Serializable)x$43 -> x$43.getMessageId()).toSet()).map((Function1 & Serializable)x -> this.toEmail(request, (Tuple2<MessageId, scala.collection.immutable.Seq<MessageResult>>)x, (MessageFastViewPrecomputedProperties)fastViewsAsMap.apply(x._1()))).handle((Function2 & Serializable)(aTry, sink) -> {
            EmailFastViewWithAttachmentsMetadataReader.$anonfun$toFastViews$12(aTry, sink);
            return BoxedUnit.UNIT;
        });
    }

    private Try<EmailView> toEmail(EmailGetRequest request, Tuple2<MessageId, scala.collection.immutable.Seq<MessageResult>> message, MessageFastViewPrecomputedProperties fastView) {
        MessageId messageId = (MessageId)message._1();
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)((IterableOnceOps)((IterableOps)message._2()).map((Function1 & Serializable)x$44 -> x$44.getMailboxId())).toList());
        String threadId = ((MessageResult)((IterableOps)message._2()).head()).getThreadId().serialize();
        return ((Try)((IterableOps)message._2()).headOption().map((Function1 & Serializable)x$45 -> new Success(x$45)).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalArgumentException("No message supplied")))).flatMap((Function1 & Serializable)firstMessage -> Email$.MODULE$.parseAsMime4JMessage((MessageResult)firstMessage).flatMap((Function1 & Serializable)mime4JMessage -> BlobId$.MODULE$.of(messageId).flatMap((Function1 & Serializable)blobId -> Email$.MODULE$.mergeKeywords((scala.collection.immutable.Seq<MessageResult>)((scala.collection.immutable.Seq)message._2())).map((Function1 & Serializable)keywords -> {
            MessageId x$1 = messageId;
            BlobId x$2 = blobId;
            String x$3 = threadId;
            MailboxIds x$4 = mailboxIds;
            UTCDate x$5 = UTCDate$.MODULE$.from(firstMessage.getInternalDate(), $this.zoneIdProvider.get());
            Long x$6 = Size$.MODULE$.sanitizeSize(firstMessage.getSize());
            Keywords x$7 = keywords;
            EmailMetadata x$8 = new EmailMetadata(x$1, x$2, x$3, x$7, x$4, x$6, x$5);
            EmailBodyMetadata x$9 = new EmailBodyMetadata(fastView.hasAttachment(), fastView.getPreview());
            EmailHeaders x$10 = EmailHeaders$.MODULE$.from($this.zoneIdProvider.get(), (Message)mime4JMessage);
            Map<String, Option<EmailHeaderValue>> x$11 = EmailHeaders$.MODULE$.extractSpecificHeaders(request.properties(), $this.zoneIdProvider.get(), mime4JMessage.getHeader());
            AttachmentsMetadata x$12 = new AttachmentsMetadata((List<EmailBodyPart>)CollectionConverters$.MODULE$.ListHasAsScala(firstMessage.getLoadedAttachments()).asScala().toList().map((Function1 & Serializable)x$46 -> EmailBodyPart$.MODULE$.fromAttachment(request.bodyProperties(), $this.zoneIdProvider.get(), (MessageAttachmentMetadata)x$46, (Message)mime4JMessage)));
            return new EmailFastViewWithAttachments(x$8, x$10, x$12, x$9, x$11);
        }))));
    }

    public static final /* synthetic */ void $anonfun$storeOnCacheMisses$2(EmailFullView fullView$2, Throwable e) {
        EmailFastViewReader$.MODULE$.logger().error("Cannot store the projection to MessageFastViewProjection for " + fullView$2.metadata().id(), e);
    }

    public static final /* synthetic */ void $anonfun$toFastViews$12(Try aTry, SynchronousSink sink) {
        Try try_ = aTry;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            EmailView value = (EmailView)success.value();
            sink.next((Object)value);
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            sink.error(e);
            return;
        }
        throw new MatchError((Object)try_);
    }

    @Inject
    public EmailFastViewWithAttachmentsMetadataReader(MessageIdManager messageIdManager, MessageFastViewProjection messageFastViewProjection, HtmlTextExtractor htmlTextExtractor, ZoneIdProvider zoneIdProvider, EmailFullViewFactory fullViewFactory) {
        this.messageIdManager = messageIdManager;
        this.messageFastViewProjection = messageFastViewProjection;
        this.zoneIdProvider = zoneIdProvider;
        this.fullReader = new GenericEmailViewReader<EmailFullView>(messageIdManager, FetchGroup.FULL_CONTENT, htmlTextExtractor, fullViewFactory);
    }
}

