/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.NoResultException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAAttachment;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ParsedAttachment;
import org.apache.james.mailbox.model.StringBackedAttachmentId;
import org.apache.james.mailbox.store.mail.AttachmentMapper;

public class JPAAttachmentMapper
extends JPATransactionalMapper
implements AttachmentMapper {
    private static final String ID_PARAM = "idParam";

    public JPAAttachmentMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    public InputStream loadAttachmentContent(AttachmentId attachmentId) {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return ((JPAAttachment)this.getEntityManager().createNamedQuery("findAttachmentById", JPAAttachment.class).setParameter(ID_PARAM, (Object)attachmentId.getId()).getSingleResult()).getContent();
    }

    public AttachmentMetadata getAttachment(AttachmentId attachmentId) throws AttachmentNotFoundException {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        AttachmentMetadata attachmentMetadata = this.getAttachmentMetadata(attachmentId);
        if (attachmentMetadata == null) {
            throw new AttachmentNotFoundException(attachmentId.getId());
        }
        return attachmentMetadata;
    }

    public List<AttachmentMetadata> getAttachments(Collection<AttachmentId> attachmentIds) {
        Preconditions.checkArgument((attachmentIds != null ? 1 : 0) != 0);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AttachmentId attachmentId : attachmentIds) {
            AttachmentMetadata attachmentMetadata = this.getAttachmentMetadata(attachmentId);
            if (attachmentMetadata == null) continue;
            builder.add((Object)attachmentMetadata);
        }
        return builder.build();
    }

    public List<MessageAttachmentMetadata> storeAttachments(Collection<ParsedAttachment> parsedAttachments, MessageId ownerMessageId) {
        Preconditions.checkArgument((parsedAttachments != null ? 1 : 0) != 0);
        Preconditions.checkArgument((ownerMessageId != null ? 1 : 0) != 0);
        return (List)parsedAttachments.stream().map(Throwing.function(typedContent -> this.storeAttachmentForMessage(ownerMessageId, (ParsedAttachment)typedContent)).sneakyThrow()).collect(ImmutableList.toImmutableList());
    }

    private AttachmentMetadata getAttachmentMetadata(AttachmentId attachmentId) {
        try {
            return ((JPAAttachment)this.getEntityManager().createNamedQuery("findAttachmentById", JPAAttachment.class).setParameter(ID_PARAM, (Object)attachmentId.getId()).getSingleResult()).toAttachmentMetadata();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private MessageAttachmentMetadata storeAttachmentForMessage(MessageId ownerMessageId, ParsedAttachment parsedAttachment) throws MailboxException {
        MessageAttachmentMetadata messageAttachmentMetadata;
        block8: {
            InputStream stream = parsedAttachment.getContent().openStream();
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                JPAAttachment persistedAttachment = new JPAAttachment(parsedAttachment.asMessageAttachment((AttachmentId)StringBackedAttachmentId.random(), ownerMessageId), bytes);
                this.getEntityManager().persist((Object)persistedAttachment);
                StringBackedAttachmentId attachmentId = StringBackedAttachmentId.from((String)persistedAttachment.getAttachmentId());
                messageAttachmentMetadata = parsedAttachment.asMessageAttachment((AttachmentId)attachmentId, (long)bytes.length, ownerMessageId);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MailboxException("Failed to store attachment for message " + String.valueOf(ownerMessageId), (Throwable)e);
                }
            }
            stream.close();
        }
        return messageAttachmentMetadata;
    }
}

