/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.LogField;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.io.Serializable;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONCertificate
implements Serializable {
    private static final long serialVersionUID = -765694943228378726L;
    @NotNull
    private final JSONObject certificateObject;
    @Nullable
    private final Long notAfterTime;
    @Nullable
    private final Long notBeforeTime;
    @Nullable
    private final String certificateType;
    @Nullable
    private final String issuerSubjectDN;
    @Nullable
    private final String serialNumber;
    @Nullable
    private final String signatureAlgorithm;
    @Nullable
    private final String subjectDN;

    public JSONCertificate(@NotNull JSONObject certificateObject) {
        this.certificateObject = certificateObject;
        this.subjectDN = certificateObject.getFieldAsString(JSONFormattedAccessLogFields.PEER_CERTIFICATE_CHAIN_SUBJECT_DN.getFieldName());
        this.issuerSubjectDN = certificateObject.getFieldAsString(JSONFormattedAccessLogFields.PEER_CERTIFICATE_CHAIN_ISSUER_SUBJECT_DN.getFieldName());
        this.certificateType = certificateObject.getFieldAsString(JSONFormattedAccessLogFields.PEER_CERTIFICATE_CHAIN_CERTIFICATE_TYPE.getFieldName());
        this.notBeforeTime = JSONCertificate.decodeTime(certificateObject, JSONFormattedAccessLogFields.PEER_CERTIFICATE_CHAIN_NOT_BEFORE);
        this.notAfterTime = JSONCertificate.decodeTime(certificateObject, JSONFormattedAccessLogFields.PEER_CERTIFICATE_CHAIN_NOT_AFTER);
        this.serialNumber = certificateObject.getFieldAsString(JSONFormattedAccessLogFields.PEER_CERTIFICATE_CHAIN_SERIAL_NUMBER.getFieldName());
        this.signatureAlgorithm = certificateObject.getFieldAsString(JSONFormattedAccessLogFields.PEER_CERTIFICATE_CHAIN_SIGNATURE_ALGORITHM.getFieldName());
    }

    @Nullable
    private static Long decodeTime(@NotNull JSONObject certificateObject, @NotNull LogField logField) {
        String timeString = certificateObject.getFieldAsString(logField.getFieldName());
        if (timeString == null) {
            return null;
        }
        try {
            return StaticUtils.decodeRFC3339Time(timeString).getTime();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @NotNull
    public JSONObject getCertificateObject() {
        return this.certificateObject;
    }

    @Nullable
    public String getSubjectDN() {
        return this.subjectDN;
    }

    @Nullable
    public String getIssuerSubjectDN() {
        return this.issuerSubjectDN;
    }

    @Nullable
    public String getCertificateType() {
        return this.certificateType;
    }

    @Nullable
    public Date getNotBeforeTime() {
        if (this.notBeforeTime == null) {
            return null;
        }
        return new Date(this.notBeforeTime);
    }

    @Nullable
    public Date getNotAfterTime() {
        if (this.notAfterTime == null) {
            return null;
        }
        return new Date(this.notAfterTime);
    }

    @Nullable
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Nullable
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public String toString() {
        return this.certificateObject.toSingleLineString();
    }
}

