/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ExtendedResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedExtendedRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedForwardAccessLogMessageHelper;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedResultAccessLogMessageHelper;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TextFormattedExtendedResultAccessLogMessage
extends TextFormattedExtendedRequestAccessLogMessage
implements ExtendedResultAccessLogMessage {
    private static final long serialVersionUID = 6860620762769239759L;
    @Nullable
    private final String clientConnectionPolicy;
    @Nullable
    private final String responseOID = this.getString(TextFormattedAccessLogFields.EXTENDED_RESPONSE_OID);
    @Nullable
    private final String responseType = this.getString(TextFormattedAccessLogFields.EXTENDED_RESPONSE_TYPE);
    @NotNull
    private final TextFormattedForwardAccessLogMessageHelper forwardHelper;
    @NotNull
    private final TextFormattedResultAccessLogMessageHelper resultHelper;

    public TextFormattedExtendedResultAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedExtendedResultAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.clientConnectionPolicy = this.getString(TextFormattedAccessLogFields.CLIENT_CONNECTION_POLICY);
        this.resultHelper = new TextFormattedResultAccessLogMessageHelper(this);
        this.forwardHelper = new TextFormattedForwardAccessLogMessageHelper(this);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.RESULT;
    }

    @Override
    @Nullable
    public ResultCode getResultCode() {
        return this.resultHelper.getResultCode();
    }

    @Override
    @Nullable
    public String getDiagnosticMessage() {
        return this.resultHelper.getDiagnosticMessage();
    }

    @Override
    @Nullable
    public String getAdditionalInformation() {
        return this.resultHelper.getAdditionalInformation();
    }

    @Override
    @Nullable
    public String getMatchedDN() {
        return this.resultHelper.getMatchedDN();
    }

    @Override
    @NotNull
    public List<String> getReferralURLs() {
        return this.resultHelper.getReferralURLs();
    }

    @Override
    @Nullable
    public Double getProcessingTimeMillis() {
        return this.resultHelper.getProcessingTimeMillis();
    }

    @Override
    @Nullable
    public Double getWorkQueueWaitTimeMillis() {
        return this.resultHelper.getWorkQueueWaitTimeMillis();
    }

    @Override
    @NotNull
    public Set<String> getResponseControlOIDs() {
        return this.resultHelper.getResponseControlOIDs();
    }

    @Override
    @Nullable
    public Long getIntermediateResponsesReturned() {
        return this.resultHelper.getIntermediateResponsesReturned();
    }

    @Override
    @NotNull
    public List<String> getServersAccessed() {
        return this.resultHelper.getServersAccessed();
    }

    @Override
    @Nullable
    public Boolean getUncachedDataAccessed() {
        return this.resultHelper.getUncachedDataAccessed();
    }

    @Override
    @NotNull
    public Set<String> getUsedPrivileges() {
        return this.resultHelper.getUsedPrivileges();
    }

    @Override
    @NotNull
    public Set<String> getPreAuthorizationUsedPrivileges() {
        return this.resultHelper.getPreAuthorizationUsedPrivileges();
    }

    @Override
    @NotNull
    public Set<String> getMissingPrivileges() {
        return this.resultHelper.getMissingPrivileges();
    }

    @Nullable
    public String getIntermediateClientResponseControl() {
        return this.resultHelper.getIntermediateClientResponseControl();
    }

    @Override
    @Nullable
    public String getTargetHost() {
        return this.forwardHelper.getTargetHost();
    }

    @Override
    @Nullable
    public Integer getTargetPort() {
        return this.forwardHelper.getTargetPort();
    }

    @Override
    @Nullable
    public String getTargetProtocol() {
        return this.forwardHelper.getTargetProtocol();
    }

    @Override
    @Nullable
    public String getResponseOID() {
        return this.responseOID;
    }

    @Override
    @Nullable
    public String getResponseType() {
        return this.responseType;
    }

    @Override
    @Nullable
    public String getClientConnectionPolicy() {
        return this.clientConnectionPolicy;
    }
}

