/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.SSLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Set;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class SetEnabledProtocolsAndCipherSuitesSocket
extends SSLSocket {
    @NotNull
    private final Set<String> cipherSuites;
    @NotNull
    private final Set<String> protocols;
    @NotNull
    private final SSLSocket delegateSocket;

    SetEnabledProtocolsAndCipherSuitesSocket(@NotNull Socket delegateSocket, @NotNull Set<String> protocols, @NotNull Set<String> cipherSuites) {
        Validator.ensureTrue(delegateSocket instanceof SSLSocket);
        Validator.ensureFalse(delegateSocket.isConnected());
        this.delegateSocket = (SSLSocket)delegateSocket;
        this.protocols = protocols;
        this.cipherSuites = cipherSuites;
    }

    @Override
    public void connect(@NotNull SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(@NotNull SocketAddress endpoint, int timeout) throws IOException {
        this.delegateSocket.connect(endpoint, timeout);
        SSLUtil.applyEnabledSSLProtocols(this.delegateSocket, this.protocols);
        SSLUtil.applyEnabledSSLCipherSuites(this.delegateSocket, this.cipherSuites);
    }

    @Override
    public void bind(@NotNull SocketAddress bindpoint) throws IOException {
        this.delegateSocket.bind(bindpoint);
    }

    @Override
    @Nullable
    public InetAddress getInetAddress() {
        return this.delegateSocket.getInetAddress();
    }

    @Override
    @Nullable
    public InetAddress getLocalAddress() {
        return this.delegateSocket.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.delegateSocket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.delegateSocket.getLocalPort();
    }

    @Override
    @Nullable
    public SocketAddress getRemoteSocketAddress() {
        return this.delegateSocket.getRemoteSocketAddress();
    }

    @Override
    @Nullable
    public SocketAddress getLocalSocketAddress() {
        return this.delegateSocket.getLocalSocketAddress();
    }

    @Override
    @Nullable
    public SocketChannel getChannel() {
        return this.delegateSocket.getChannel();
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        return this.delegateSocket.getInputStream();
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() throws IOException {
        return this.delegateSocket.getOutputStream();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.delegateSocket.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.delegateSocket.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.delegateSocket.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.delegateSocket.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new SocketException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_URGENT_DATA_NOT_SUPPORTED.get());
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_URGENT_DATA_NOT_SUPPORTED.get());
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        throw new SocketException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_URGENT_DATA_NOT_SUPPORTED.get());
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.delegateSocket.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.delegateSocket.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.delegateSocket.setSendBufferSize(size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.delegateSocket.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegateSocket.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.delegateSocket.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.delegateSocket.setKeepAlive(on);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.delegateSocket.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.delegateSocket.setTrafficClass(tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.delegateSocket.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.delegateSocket.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.delegateSocket.getReuseAddress();
    }

    @Override
    public void close() throws IOException {
        this.delegateSocket.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_SHUTDOWN_INPUT.get());
    }

    @Override
    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_SHUTDOWN_OUTPUT.get());
    }

    @Override
    public boolean isConnected() {
        return this.delegateSocket.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.delegateSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.delegateSocket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.delegateSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.delegateSocket.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.delegateSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        return this.delegateSocket.getSupportedCipherSuites();
    }

    @Override
    @NotNull
    public String[] getEnabledCipherSuites() {
        return this.delegateSocket.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(@NotNull String[] suites) {
        this.delegateSocket.setEnabledCipherSuites(suites);
    }

    @Override
    @NotNull
    public String[] getSupportedProtocols() {
        return this.delegateSocket.getSupportedProtocols();
    }

    @Override
    @NotNull
    public String[] getEnabledProtocols() {
        return this.delegateSocket.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(@NotNull String[] protocols) {
        this.delegateSocket.setEnabledProtocols(protocols);
    }

    @Override
    @NotNull
    public SSLSession getSession() {
        return this.delegateSocket.getSession();
    }

    @Override
    public void addHandshakeCompletedListener(@NotNull HandshakeCompletedListener listener) {
        this.delegateSocket.addHandshakeCompletedListener(listener);
    }

    @Override
    public void removeHandshakeCompletedListener(@NotNull HandshakeCompletedListener listener) {
        this.delegateSocket.removeHandshakeCompletedListener(listener);
    }

    @Override
    public void startHandshake() throws IOException {
        this.delegateSocket.startHandshake();
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.delegateSocket.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.delegateSocket.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.delegateSocket.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.delegateSocket.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.delegateSocket.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.delegateSocket.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.delegateSocket.setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.delegateSocket.getEnableSessionCreation();
    }

    @Override
    @NotNull
    public String toString() {
        return this.delegateSocket.toString();
    }
}

