/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.SerializerRDF;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.sparql.core.Quad;
import org.apache.thrift.protocol.TProtocol;

public final class SQuad
implements Serializable {
    private static final long serialVersionUID = -7406960748415222010L;
    private transient Quad quad;

    public SQuad(Quad quad) {
        this.quad = quad;
    }

    public Quad getQuad() {
        return this.quad;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        TProtocol protocol = TRDF.protocol(out);
        RDF_Term tterm = new RDF_Term();
        SerializerRDF.write(protocol, tterm, this.quad.getGraph());
        SerializerRDF.write(protocol, tterm, this.quad.getSubject());
        SerializerRDF.write(protocol, tterm, this.quad.getPredicate());
        SerializerRDF.write(protocol, tterm, this.quad.getObject());
        TRDF.flush(protocol);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        TProtocol protocol = TRDF.protocol(in);
        RDF_Term tterm = new RDF_Term();
        Node g = SerializerRDF.read(protocol, tterm);
        Node s = SerializerRDF.read(protocol, tterm);
        Node p = SerializerRDF.read(protocol, tterm);
        Node o = SerializerRDF.read(protocol, tterm);
        this.quad = Quad.create(g, s, p, o);
    }

    Object readResolve() throws ObjectStreamException {
        return this.quad;
    }
}

