/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem.collection;

import org.apache.jena.mem.collection.HashCommonBase;
import org.apache.jena.mem.collection.JenaSet;

public abstract class HashCommonSet<K>
extends HashCommonBase<K>
implements JenaSet<K> {
    protected HashCommonSet(int initialCapacity) {
        super(initialCapacity);
    }

    protected HashCommonSet(HashCommonSet<K> setToCopy) {
        super(setToCopy);
    }

    @Override
    public boolean tryAdd(K key) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            return false;
        }
        this.keys[slot] = key;
        if (++this.size > this.threshold) {
            this.grow();
        }
        return true;
    }

    @Override
    public void addUnchecked(K key) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            return;
        }
        this.keys[slot] = key;
        if (++this.size > this.threshold) {
            this.grow();
        }
    }

    @Override
    protected void grow() {
        Object[] oldContents = this.keys;
        this.keys = this.newKeysArray(this.calcGrownCapacityAndSetThreshold());
        for (Object key : oldContents) {
            if (key == null) continue;
            int slot = this.findSlot(key);
            this.keys[slot] = key;
        }
    }

    @Override
    protected void removeFrom(int here) {
        --this.size;
        while (true) {
            int r;
            this.keys[here] = null;
            int scan = here;
            do {
                if (--scan < 0) {
                    scan += this.keys.length;
                }
                if (this.keys[scan] != null) continue;
                return;
            } while (scan <= (r = this.initialIndexFor(this.keys[scan].hashCode())) && r < here || r < here && here < scan || here < scan && scan <= r);
            this.keys[here] = this.keys[scan];
            here = scan;
        }
    }
}

