/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheusmetrics;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.prometheusmetrics.ExemplarSamplerFactory;
import io.prometheus.metrics.core.exemplars.ExemplarSampler;
import io.prometheus.metrics.model.snapshots.Exemplar;
import java.util.concurrent.atomic.DoubleAdder;
import org.jspecify.annotations.Nullable;

public class PrometheusCounter
extends AbstractMeter
implements Counter {
    private final DoubleAdder count = new DoubleAdder();
    private final @Nullable ExemplarSampler exemplarSampler;

    PrometheusCounter(Meter.Id id) {
        this(id, null);
    }

    PrometheusCounter(Meter.Id id, @Nullable ExemplarSamplerFactory exemplarSamplerFactory) {
        super(id);
        this.exemplarSampler = exemplarSamplerFactory != null ? exemplarSamplerFactory.createExemplarSampler(1) : null;
    }

    @Override
    public void increment(double amount) {
        if (amount > 0.0) {
            this.count.add(amount);
            if (this.exemplarSampler != null) {
                this.exemplarSampler.observe(amount);
            }
        }
    }

    @Override
    public double count() {
        return this.count.doubleValue();
    }

    @Nullable Exemplar exemplar() {
        return this.exemplarSampler != null ? this.exemplarSampler.collect().getLatest() : null;
    }
}

