/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.SegmentCacheable;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.Bits;

public abstract class Weight
implements SegmentCacheable {
    protected final Query parentQuery;

    protected Weight(Query query2) {
        this.parentQuery = query2;
    }

    public Matches matches(LeafReaderContext context2, int doc) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context2);
        if (scorerSupplier == null) {
            return null;
        }
        Scorer scorer = scorerSupplier.get(1L);
        TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
        if (twoPhase == null ? scorer.iterator().advance(doc) != doc : twoPhase.approximation().advance(doc) != doc || !twoPhase.matches()) {
            return null;
        }
        return MatchesUtils.MATCH_WITH_NO_TERMS;
    }

    public abstract Explanation explain(LeafReaderContext var1, int var2) throws IOException;

    public final Query getQuery() {
        return this.parentQuery;
    }

    public final Scorer scorer(LeafReaderContext context2) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context2);
        if (scorerSupplier == null) {
            return null;
        }
        return scorerSupplier.get(Long.MAX_VALUE);
    }

    public abstract ScorerSupplier scorerSupplier(LeafReaderContext var1) throws IOException;

    public final BulkScorer bulkScorer(LeafReaderContext context2) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context2);
        if (scorerSupplier == null) {
            return null;
        }
        scorerSupplier.setTopLevelScoringClause();
        return scorerSupplier.bulkScorer();
    }

    public int count(LeafReaderContext context2) throws IOException {
        return -1;
    }

    protected static class DefaultBulkScorer
    extends BulkScorer {
        private final Scorer scorer;
        private final DocIdSetIterator iterator;
        private final TwoPhaseIterator twoPhase;

        public DefaultBulkScorer(Scorer scorer) {
            this.scorer = Objects.requireNonNull(scorer);
            this.twoPhase = scorer.twoPhaseIterator();
            this.iterator = this.twoPhase == null ? scorer.iterator() : this.twoPhase.approximation();
        }

        @Override
        public long cost() {
            return this.iterator.cost();
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
            collector.setScorer(this.scorer);
            DocIdSetIterator competitiveIterator = collector.competitiveIterator();
            if (competitiveIterator != null && competitiveIterator.docID() > min2) {
                min2 = competitiveIterator.docID();
                min2 = Math.min(min2, max2);
            }
            if (this.iterator.docID() < min2) {
                if (this.iterator.docID() == min2 - 1) {
                    this.iterator.nextDoc();
                } else {
                    this.iterator.advance(min2);
                }
            }
            if (this.twoPhase == null && competitiveIterator == null) {
                DefaultBulkScorer.scoreIterator(collector, acceptDocs, this.iterator, max2);
            } else if (competitiveIterator == null) {
                DefaultBulkScorer.scoreTwoPhaseIterator(collector, acceptDocs, this.iterator, this.twoPhase, max2);
            } else if (this.twoPhase == null) {
                DefaultBulkScorer.scoreCompetitiveIterator(collector, acceptDocs, this.iterator, competitiveIterator, max2);
            } else {
                DefaultBulkScorer.scoreTwoPhaseOrCompetitiveIterator(collector, acceptDocs, this.iterator, this.twoPhase, competitiveIterator, max2);
            }
            return this.iterator.docID();
        }

        private static void scoreIterator(LeafCollector collector, Bits acceptDocs, DocIdSetIterator iterator, int max2) throws IOException {
            int doc = iterator.docID();
            while (doc < max2) {
                if (acceptDocs == null || acceptDocs.get(doc)) {
                    collector.collect(doc);
                }
                doc = iterator.nextDoc();
            }
        }

        private static void scoreTwoPhaseIterator(LeafCollector collector, Bits acceptDocs, DocIdSetIterator iterator, TwoPhaseIterator twoPhase, int max2) throws IOException {
            int doc = iterator.docID();
            while (doc < max2) {
                if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                    collector.collect(doc);
                }
                doc = iterator.nextDoc();
            }
        }

        private static void scoreCompetitiveIterator(LeafCollector collector, Bits acceptDocs, DocIdSetIterator iterator, DocIdSetIterator competitiveIterator, int max2) throws IOException {
            int doc = iterator.docID();
            while (doc < max2) {
                int competitiveNext;
                assert (competitiveIterator.docID() <= doc);
                if (competitiveIterator.docID() < doc && (competitiveNext = competitiveIterator.advance(doc)) != doc) {
                    doc = iterator.advance(competitiveNext);
                    continue;
                }
                if (acceptDocs == null || acceptDocs.get(doc)) {
                    collector.collect(doc);
                }
                doc = iterator.nextDoc();
            }
        }

        private static void scoreTwoPhaseOrCompetitiveIterator(LeafCollector collector, Bits acceptDocs, DocIdSetIterator iterator, TwoPhaseIterator twoPhase, DocIdSetIterator competitiveIterator, int max2) throws IOException {
            int doc = iterator.docID();
            while (doc < max2) {
                int competitiveNext;
                assert (competitiveIterator.docID() <= doc);
                if (competitiveIterator.docID() < doc && (competitiveNext = competitiveIterator.advance(doc)) != doc) {
                    doc = iterator.advance(competitiveNext);
                    continue;
                }
                if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                    collector.collect(doc);
                }
                doc = iterator.nextDoc();
            }
        }
    }

    protected static final class DefaultScorerSupplier
    extends ScorerSupplier {
        private final Scorer scorer;

        public DefaultScorerSupplier(Scorer scorer) {
            this.scorer = Objects.requireNonNull(scorer, "Scorer must not be null");
        }

        @Override
        public Scorer get(long leadCost) throws IOException {
            return this.scorer;
        }

        @Override
        public long cost() {
            return this.scorer.iterator().cost();
        }
    }
}

