/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.JceKEM;
import org.apache.sshd.common.util.security.KEM;

public interface SecurityEntityFactory {
    default public AlgorithmParameters createAlgorithmParameters(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public CertificateFactory createCertificateFactory(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public Cipher createCipher(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public KeyAgreement createKeyAgreement(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public KeyFactory createKeyFactory(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public KeyPairGenerator createKeyPairGenerator(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public Mac createMac(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public MessageDigest createMessageDigest(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public Signature createSignature(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public SecureRandom createSecureRandom(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    default public KEM createKEM(String algorithm) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Algorithm '" + algorithm + "' not supported (default)");
    }

    public static enum Default implements SecurityEntityFactory
    {
        INSTANCE;


        @Override
        public AlgorithmParameters createAlgorithmParameters(String algorithm) throws GeneralSecurityException {
            return AlgorithmParameters.getInstance(algorithm);
        }

        @Override
        public CertificateFactory createCertificateFactory(String algorithm) throws GeneralSecurityException {
            return CertificateFactory.getInstance(algorithm);
        }

        @Override
        public Cipher createCipher(String algorithm) throws GeneralSecurityException {
            return Cipher.getInstance(algorithm);
        }

        @Override
        public KeyAgreement createKeyAgreement(String algorithm) throws GeneralSecurityException {
            return KeyAgreement.getInstance(algorithm);
        }

        @Override
        public KeyFactory createKeyFactory(String algorithm) throws GeneralSecurityException {
            return KeyFactory.getInstance(algorithm);
        }

        @Override
        public KeyPairGenerator createKeyPairGenerator(String algorithm) throws GeneralSecurityException {
            return KeyPairGenerator.getInstance(algorithm);
        }

        @Override
        public Mac createMac(String algorithm) throws GeneralSecurityException {
            return Mac.getInstance(algorithm);
        }

        @Override
        public MessageDigest createMessageDigest(String algorithm) throws GeneralSecurityException {
            return MessageDigest.getInstance(algorithm);
        }

        @Override
        public Signature createSignature(String algorithm) throws GeneralSecurityException {
            return Signature.getInstance(algorithm);
        }

        @Override
        public SecureRandom createSecureRandom(String algorithm) throws GeneralSecurityException {
            return SecureRandom.getInstance(algorithm);
        }

        @Override
        public KEM createKEM(String algorithm) throws GeneralSecurityException {
            return JceKEM.INSTANCE.get(algorithm);
        }
    }

    public static class ByProvider
    implements SecurityEntityFactory {
        private final Provider provider;

        public ByProvider(Provider name) {
            this.provider = ValidateUtils.checkNotNull(name, "Security provider must not be null");
        }

        @Override
        public AlgorithmParameters createAlgorithmParameters(String algorithm) throws GeneralSecurityException {
            return AlgorithmParameters.getInstance(algorithm, this.provider);
        }

        @Override
        public CertificateFactory createCertificateFactory(String algorithm) throws GeneralSecurityException {
            return CertificateFactory.getInstance(algorithm, this.provider);
        }

        @Override
        public Cipher createCipher(String algorithm) throws GeneralSecurityException {
            return Cipher.getInstance(algorithm, this.provider);
        }

        @Override
        public KeyAgreement createKeyAgreement(String algorithm) throws GeneralSecurityException {
            return KeyAgreement.getInstance(algorithm, this.provider);
        }

        @Override
        public KeyFactory createKeyFactory(String algorithm) throws GeneralSecurityException {
            return KeyFactory.getInstance(algorithm, this.provider);
        }

        @Override
        public KeyPairGenerator createKeyPairGenerator(String algorithm) throws GeneralSecurityException {
            return KeyPairGenerator.getInstance(algorithm, this.provider);
        }

        @Override
        public Mac createMac(String algorithm) throws GeneralSecurityException {
            return Mac.getInstance(algorithm, this.provider);
        }

        @Override
        public MessageDigest createMessageDigest(String algorithm) throws GeneralSecurityException {
            return MessageDigest.getInstance(algorithm, this.provider);
        }

        @Override
        public Signature createSignature(String algorithm) throws GeneralSecurityException {
            return Signature.getInstance(algorithm, this.provider);
        }

        @Override
        public SecureRandom createSecureRandom(String algorithm) throws GeneralSecurityException {
            return SecureRandom.getInstance(algorithm, this.provider);
        }
    }

    public static class Named
    implements SecurityEntityFactory {
        private final String name;

        public Named(String name) {
            this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "Security provider name must not be empty");
        }

        @Override
        public AlgorithmParameters createAlgorithmParameters(String algorithm) throws GeneralSecurityException {
            return AlgorithmParameters.getInstance(algorithm, this.name);
        }

        @Override
        public CertificateFactory createCertificateFactory(String algorithm) throws GeneralSecurityException {
            return CertificateFactory.getInstance(algorithm, this.name);
        }

        @Override
        public Cipher createCipher(String algorithm) throws GeneralSecurityException {
            return Cipher.getInstance(algorithm, this.name);
        }

        @Override
        public KeyAgreement createKeyAgreement(String algorithm) throws GeneralSecurityException {
            return KeyAgreement.getInstance(algorithm, this.name);
        }

        @Override
        public KeyFactory createKeyFactory(String algorithm) throws GeneralSecurityException {
            return KeyFactory.getInstance(algorithm, this.name);
        }

        @Override
        public KeyPairGenerator createKeyPairGenerator(String algorithm) throws GeneralSecurityException {
            return KeyPairGenerator.getInstance(algorithm, this.name);
        }

        @Override
        public Mac createMac(String algorithm) throws GeneralSecurityException {
            return Mac.getInstance(algorithm, this.name);
        }

        @Override
        public MessageDigest createMessageDigest(String algorithm) throws GeneralSecurityException {
            return MessageDigest.getInstance(algorithm, this.name);
        }

        @Override
        public Signature createSignature(String algorithm) throws GeneralSecurityException {
            return Signature.getInstance(algorithm, this.name);
        }

        @Override
        public SecureRandom createSecureRandom(String algorithm) throws GeneralSecurityException {
            return SecureRandom.getInstance(algorithm, this.name);
        }
    }
}

