/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.options;

import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.options.OptionsCategoryImpl;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.ImageUtilities;

public abstract class OptionsCategory {
    private static final String TITLE = "title";
    private static final String CATEGORY_NAME = "categoryName";
    private static final String ICON = "iconBase";
    private static final String CONTROLLER = "controller";
    private static final String KEYWORDS = "keywords";
    private static final String KEYWORDS_CATEGORY = "keywordsCategory";
    private static final String ADVANCED_OPTIONS_FOLDER = "advancedOptionsFolder";

    @Deprecated
    public String getIconBase() {
        return null;
    }

    public Icon getIcon() {
        ImageIcon res = ImageUtilities.loadImageIcon(this.getIconBase() + ".png", true);
        if (res == null) {
            res = ImageUtilities.loadImageIcon(this.getIconBase() + ".gif", true);
        }
        return res;
    }

    public abstract String getCategoryName();

    public abstract String getTitle();

    public abstract OptionsPanelController create();

    static OptionsCategory createCategory(final Map attrs) {
        final String title = (String)attrs.get(TITLE);
        String categoryName = (String)attrs.get(CATEGORY_NAME);
        String iconBase = (String)attrs.get(ICON);
        String keywords = (String)attrs.get(KEYWORDS);
        String keywordsCategory = (String)attrs.get(KEYWORDS_CATEGORY);
        String advancedOptionsCategory = (String)attrs.get(ADVANCED_OPTIONS_FOLDER);
        return new OptionsCategoryImpl(title, categoryName, iconBase, new Callable<OptionsPanelController>(){

            @Override
            public OptionsPanelController call() throws Exception {
                Object o = attrs.get(OptionsCategory.CONTROLLER);
                if (o instanceof OptionsPanelController) {
                    return (OptionsPanelController)o;
                }
                throw new Exception("got no controller from " + title + ": " + o);
            }
        }, keywords, keywordsCategory, advancedOptionsCategory);
    }
}

